% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/1_ModelsHeader.R, R/2_SimpleModels.R, R/3_ComplexModels.R, R/4_NetworkModels.R, R/5_SimulateModels.R
\name{Pn}
\alias{Pn}
\alias{Pn.ClosedJackson}
\alias{Pn.M_M_1}
\alias{Pn.M_M_1_INF_H}
\alias{Pn.M_M_1_K}
\alias{Pn.M_M_INF}
\alias{Pn.M_M_S}
\alias{Pn.M_M_S_INF_H}
\alias{Pn.M_M_S_INF_H_Y}
\alias{Pn.M_M_S_K}
\alias{Pn.MarkovianModel}
\alias{Pn.OpenJackson}
\alias{Pn.SimulatedModel}
\title{Steady-state probability of having n customers in the system}
\usage{
Pn(qm, n)
}
\arguments{
\item{qm}{Queueing model}

\item{n}{Number of customers. With \code{OpenJacksonNetwork} objects must be a vector with same length as nodes. With \code{ClosedJacksonNetwork} objects also the sum the vector must be equal to the number of customers in the network.}
}
\value{
\ifelse{latex}{\deqn{P_n}}{\out{<i>P<sub>n</sub></i>}}
}
\description{
Returns the probability of having n customers in the given queueing model
}
\section{Methods (by class)}{
\itemize{
\item \code{MarkovianModel}: Implements the method for a Markovian model

\item \code{M_M_1}: Implements the method for a M/M/1 queueing model

\item \code{M_M_S}: Implements the method for a M/M/s queueing model

\item \code{M_M_1_K}: Implements the method for a M/M/1/K queueing model

\item \code{M_M_S_K}: Implements the method for a M/M/s/K queueing model

\item \code{M_M_1_INF_H}: implements the method for a M/M/1/\eqn{\infty}/H queueing model

\item \code{M_M_S_INF_H}: Implements the method for a M/M/s/\eqn{\infty}/H queueing model

\item \code{M_M_S_INF_H_Y}: Implements the method for a M/M/s/\eqn{\infty}/H/Y queueing model

\item \code{M_M_INF}: Implements the method for a M_M_INF queueing model

\item \code{OpenJackson}: Implements the method for a Open Jackson Network model

\item \code{ClosedJackson}: Implements the method for a Closed Jackson Network model

\item \code{SimulatedModel}: Implements the method for a Simulated model
}}
\examples{
#Probability of having one customer in the
#system
Pn(M_M_S(), 1)
Pn(M_M_INF(), 1)

#You can also get multiple probabilities
#at once
Pn(M_M_1_INF_H(), 0:5)
Pn(M_M_S_K(), 1:3)

#With networks must be a vector with
#same length as nodes

#Probability of having 0 customers in
#the node 1, and 2 customers in node 2
Pn(OpenJacksonNetwork(), c(0, 2))

#Probability of having 1,2,0, and 0
#customers in nodes 1,2,3 and 4 respectively
Pn(ClosedJacksonNetwork(), c(1,2,0,0))
}

