% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/describe.R
\docType{methods}
\name{describe}
\alias{describe}
\alias{describe-method}
\alias{describe,ANY-method}
\title{Data Description}
\usage{
describe(x, ...)

\S4method{describe}{ANY}(x)
}
\arguments{
\item{x}{An \R object (should be a \code{\link{matrix}} or a \code{\link{data.frame}}).}

\item{...}{Currently not used.}
}
\value{
\code{describe()} is called for its side-effects. Invisibly returns \code{x}.
}
\description{
Describes an object.
}
\examples{
## Create a data matrix
X <- matrix(sample(0:9, 15, TRUE), nrow = 3, ncol = 5)

## Add NA
k <- sample(1:15, 3, FALSE)
X[k] <- NA

## Sparsity
sparsity(X)

## Quick description
describe(X)
}
\seealso{
Other data summaries: 
\code{\link{sparsity}()}
}
\author{
N. Frerebeau
}
\concept{data summaries}
