% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{check-attribute}
\alias{check-attribute}
\alias{assert_empty}
\alias{assert_filled}
\alias{assert_length}
\alias{assert_lengths}
\alias{assert_dimensions}
\alias{assert_names}
\alias{assert_dimnames}
\alias{assert_rownames}
\alias{assert_colnames}
\title{Check Object Attributes}
\usage{
assert_empty(x)

assert_filled(x)

assert_length(x, expected, empty = FALSE)

assert_lengths(x, expected)

assert_dimensions(x, expected)

assert_names(x, expected)

assert_dimnames(x, expected)

assert_rownames(x, expected)

assert_colnames(x, expected)
}
\arguments{
\item{x}{An object to be checked.}

\item{expected}{An appropriate expected value.}

\item{empty}{A \code{\link{logical}} scalar: should empty objects be ignored?}
}
\value{
Throws an error, if any, and returns \code{x} invisibly otherwise.
}
\description{
Check Object Attributes
}
\seealso{
Other validation methods: 
\code{\link{check-data}},
\code{\link{check-matrix}},
\code{\link{check-numeric-comparison}},
\code{\link{check-numeric-trend}},
\code{\link{check-numeric}},
\code{\link{check-type}},
\code{\link{validate}()}
}
\author{
N. Frerebeau
}
\concept{validation methods}
