% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/replace.R
\docType{methods}
\name{replace}
\alias{replace}
\alias{replace_NA}
\alias{replace_NA-method}
\alias{replace_Inf}
\alias{replace_Inf-method}
\alias{replace_zero}
\alias{replace_zero-method}
\alias{replace_NA,matrix-method}
\alias{replace_Inf,matrix-method}
\alias{replace_zero,matrix-method}
\title{Data Replacement}
\usage{
replace_NA(x, ...)

replace_Inf(x, ...)

replace_zero(x, ...)

\S4method{replace_NA}{matrix}(x, value = 0)

\S4method{replace_Inf}{matrix}(x, value = 0)

\S4method{replace_zero}{matrix}(x, value)
}
\arguments{
\item{x}{A \code{\link{matrix}}, a \code{\link{data.frame}} or a \verb{*Matrix} object.}

\item{...}{Currently not used.}

\item{value}{A possible value to replace missing or infinite values of \code{x}.}
}
\description{
Replaces \code{\link[=NA]{missing}} or \code{\link[=is.finite]{infinite}} values or zeros.
}
\examples{
## Create a count data matrix
X <- matrix(sample(1:10, 25, TRUE), nrow = 5, ncol = 5)

## Add NA
k <- sample(1:25, 3, FALSE)
X[k] <- NA
X

## Count missing values in rows
count(X, f = is.na, margin = 1)
## Count non-missing values in columns
count(X, f = is.na, margin = 2, negate = TRUE)

## Find row with NA
detect(X, f = is.na, margin = 1)
## Find column without any NA
detect(X, f = is.na, margin = 2, negate = TRUE, all = TRUE)

## Remove row with any NA
compact(X, f = is.na, margin = 1, all = FALSE)
## Remove column with any NA
compact(X, f = is.na, margin = 2, all = FALSE)

## Replace NA with zeros
replace_NA(X, value = 0)
}
\seealso{
Other data cleaning tools: 
\code{\link{assign}()},
\code{\link{count}()},
\code{\link{detect}()},
\code{\link{remove}()}
}
\author{
N. Frerebeau
}
\concept{data cleaning tools}
