% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{getProfileFromUrl}
\alias{getProfileFromUrl}
\title{Get Data for an Argo Float Profile}
\usage{
getProfileFromUrl(
  url = NULL,
  destdir = argoDefaultDestdir(),
  destfile = NULL,
  age = argoDefaultProfileAge(),
  retries = 3,
  quiet = FALSE,
  debug = 0
)
}
\arguments{
\item{url}{character value giving the URL for a NetCDF file containing an
particular profile of a particular Argo float.}

\item{destdir}{character value indicating the directory in which to store
downloaded files. The default value is to compute this using
\code{\link[=argoDefaultDestdir]{argoDefaultDestdir()}}, which returns \verb{~/data/argo} by default,
although it also provides ways to set other values using
\code{\link[=options]{options()}}.
Set \code{destdir=NULL}
if \code{destfile} is a filename with full path information.
File clutter is reduced by creating a top-level directory called
\code{data}, with subdirectories for various file types; see
\dQuote{Examples}.}

\item{destfile}{optional character value that specifies the name to be used
for the downloaded file. If this is not specified, then a name is determined
from the value of \code{url}.}

\item{age}{a numerical value indicating a time interval, in days.  If the file
to be downloaded from the server already exists locally, and was created
is less than \code{age} days in the past, it will not be downloaded.  The default,
\code{\link[=argoDefaultProfileAge]{argoDefaultProfileAge()}}, is one year.  Setting \code{age=0} will force a download.}

\item{retries}{integer telling how many times to retry a download,
if the first attempt fails.}

\item{quiet}{logical value; use \code{TRUE} to show more
verbose information when downloading files.
(Problems will still be reported, though.)}

\item{debug}{integer value indicating level of debugging. If this
is less than 1, no debugging is done. Otherwise, some functions
will print debugging information.  If a function call fails, the
first step should be to rerun the function with \code{debug=1},
to see if the output suggests a problem in the call.}
}
\value{
A character value naming the local location of the downloaded file,
or \code{NULL} if the file could not be downloaded.
}
\description{
Get Data for an Argo Float Profile
}
\author{
Dan Kelley
}
