% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funnel_measure.R
\name{funnel_measure}
\alias{funnel_measure}
\title{Internal function for calculating data for funnel plot}
\usage{
funnel_measure(
  explainer,
  measure_function = NULL,
  nbins = 5,
  cutoff = 0.01,
  cutoff_name = "Other",
  factor_conversion_threshold = 7
)
}
\arguments{
\item{explainer}{Explainer created using \code{DALEX::explain}}

\item{measure_function}{measure function that calculates performance of model based on true observation and prediction.
Order of parameters is important and should be (y, y_hat). The measure calculated by the function
should have the property that lower score value indicates better model. If NULL, RMSE will be used for regression,
  one minus auc for classification and crossentropy for multiclass classification.}

\item{nbins}{Number of qunatiles (partition points) for numeric columns. In case when more than one qunatile have the same value, there will be less partition points.}

\item{cutoff}{Threshold for categorical data. Entries less frequent than specified value will be merged into one category.}

\item{cutoff_name}{Name for new category that arised after merging entries less frequent than \code{cutoff}}

\item{factor_conversion_threshold}{Numeric columns with lower number of unique values than value of this parameter will be treated as factors}
}
\value{
Data frame with columns
\itemize{
  \item{Variable}{ Name of splited variable}
  \item{Measure}{ Loss value for subset}
  \item{Label}{ Label for variable's values subset}
}
}
\description{
This is simplified version of \code{DALEXtra::funnel_measure}
}
