% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deleteRepo.R
\name{deleteLocalRepo}
\alias{deleteLocalRepo}
\alias{deleteRepo}
\title{Delete the Existing Repository from the Given Directory}
\usage{
deleteLocalRepo(repoDir, deleteRoot = FALSE, unset = FALSE)

deleteRepo(...)
}
\arguments{
\item{repoDir}{A character that specifies the directory for the Repository
which is to be deleted.}

\item{deleteRoot}{A logical value that specifies if the repository root directory
should be deleted for Local Repository.}

\item{unset}{A logical. If deleted \code{repoDir} was set to be default Local Repository
and \code{unset} is TRUE, then \code{repoDir} is unset as a default Local  Repository (\code{aoptions('repoDir/repo', NULL, T)}).}

\item{...}{All arguments are being passed to \code{deleteLocalRepo}.}
}
\description{
\code{deleteLocalRepo} deletes the existing \link{Repository} from the given directory.
As a result all artifacts from \code{gallery} folder are removed and database \code{backpack.db}
is deleted.
}
\note{
Remember that using \code{tempfile()} instead of \code{tempdir()}
in examples section is crucial. \code{tempdir()} is existing directory
in which R works so calling \code{deleteLocalRepo(exampleRepoDir, deleteRoot=TRUE)}
removes important R files. You can find out more information about this problem at 
\href{http://stackoverflow.com/questions/22325820/unlink-function-causing-an-error-for-consequent-and-plot-functions}{stackoverflow}
webpage.
}
\section{Contact}{

 
Bug reports and feature requests can be sent to 
\href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}

\examples{

exampleRepoDir <- tempfile()
createLocalRepo( repoDir = exampleRepoDir, default =  TRUE )
data(iris)
saveToLocalRepo(iris)
deleteLocalRepo( repoDir = exampleRepoDir, unset = TRUE, deleteRoot = TRUE)

}
\references{
Biecek P and Kosinski M (2017). "archivist: An R Package for Managing,
Recording and Restoring Data Analysis Results." _Journal of Statistical
Software_, *82*(11), pp. 1-28. doi: 10.18637/jss.v082.i11 (URL:
http://doi.org/10.18637/jss.v082.i11).
URL https://github.com/pbiecek/archivist
}
\seealso{
Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}},
  \code{\link{areadLocal}}, \code{\link{aread}},
  \code{\link{asearchLocal}}, \code{\link{asearch}},
  \code{\link{asession}}, \code{\link{atrace}},
  \code{\link{cache}}, \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{removeTagsRepo}}, \code{\link{restoreLibs}},
  \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}

Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}},
  \code{\link{areadLocal}}, \code{\link{aread}},
  \code{\link{asearchLocal}}, \code{\link{asearch}},
  \code{\link{asession}}, \code{\link{atrace}},
  \code{\link{cache}}, \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{removeTagsRepo}}, \code{\link{restoreLibs}},
  \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\concept{archivist}
