% Generated by roxygen2 (4.0.0): do not edit by hand
\name{getTagsLocal}
\alias{getTagsGithub}
\alias{getTagsLocal}
\title{Return a Tag Corresponding to md5hash}
\usage{
getTagsLocal(md5hash, repoDir, tag = "name")

getTagsGithub(md5hash, user, repo, branch = "master", repoDirGit = FALSE,
  tag = "name")
}
\arguments{
  \item{repoDir}{A character denoting an existing directory
  in which an artifact is stored.}

  \item{md5hash}{A character containing \code{md5hash} of
  artifacts which \code{Tag} is desired to be returned.}

  \item{tag}{A type of a \link{Tags}. Default \code{tag =
  "name"}.}

  \item{repo}{Only if working with a Github repository. A
  character containing a name of a Github repository on
  which the Repository is archived.}

  \item{user}{Only if working with a Github repository. A
  character containing a name of a Github user on whose
  account the \code{repo} is created.}

  \item{branch}{Only if working with a Github repository. A
  character containing a name of Github repository's branch
  in which Repository is archived. Default \code{branch} is
  \code{master}.}

  \item{repoDirGit}{Only if working with a Github
  repository. A character containing a name of a directory
  on Github repository on which the Repository is stored.
  If the Repository is stored in main folder on Github
  repository, this should be set to \code{repoDirGit =
  FALSE} as default.}
}
\value{
The character is returned, which is a \code{Tag} (see
\link{Tags}) related to \link{md5hash} of an artifact.
}
\description{
\code{getTagsLocal} and \code{getTagsGithub} return a
\code{Tag} (see \link{Tags}) related to \link{md5hash} of
an artifact. To learn more about artifacts visit
\link[archivist]{archivist-package}.
}
\details{
\code{getTagsLocal} and \code{getTagsGithub} return (see
\link{Tags}) related to \link{md5hash} of an artifact. To
learn more about artifacts visit
\link[archivist]{archivist-package}.
}
\examples{
\dontrun{
library(dplyr)
exampleRepoDir <- tempdir()
createEmptyRepo( exampleRepoDir )

data(mtcars)
hash <- mtcars \%.\%
 group_by(cyl, am) \%.\%
 select(mpg, cyl, wt, am) \%.\%
 summarise(avgmpg = mean(mpg), avgwt = mean(wt)) \%.\%
 filter(avgmpg > 20) \%>\%
 saveToRepo( exampleRepoDir )

getTagsLocal( md5hash = hash, exampleRepoDir )

deleteRepo( exampleRepoDir )
rm( exampleRepoDir )

getTagsGithub( "3db63bc63b8defaf42c0bde19160f242",
   user="pbiecek", repo="archivist")

# many archivist-like Repositories on one Github repository

getTagsGithub("ff575c261c949d073b2895b05d1097c3", user="MarcinKosinski",
repo="Museum", branch="master", repoDirGit="ex1")

}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}};
\code{\link{Tags}}; \code{\link{archivist-package}};
\code{\link{copyGithubRepo}}, \code{\link{copyLocalRepo}};
\code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
\code{\link{loadFromGithubRepo}},
\code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
\code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
\code{\link{searchInGithubRepo}},
\code{\link{searchInLocalRepo}};
\code{\link{showGithubRepo}}, \code{\link{showLocalRepo}};
\code{\link{summaryGithubRepo}},
\code{\link{summaryLocalRepo}};
\code{\link{tarGithubRepo}}, \code{\link{tarLocalRepo}}

Other archivist: \code{\link{Repository}};
\code{\link{Tags}}; \code{\link{archivist-package}};
\code{\link{copyGithubRepo}}, \code{\link{copyLocalRepo}};
\code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
\code{\link{loadFromGithubRepo}},
\code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
\code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
\code{\link{searchInGithubRepo}},
\code{\link{searchInLocalRepo}};
\code{\link{showGithubRepo}}, \code{\link{showLocalRepo}};
\code{\link{summaryGithubRepo}},
\code{\link{summaryLocalRepo}};
\code{\link{tarGithubRepo}}, \code{\link{tarLocalRepo}}
}

