% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{arc_spatial_references}
\alias{arc_spatial_references}
\title{ESRI (ArcGIS) Spatial Reference data base}
\format{
A \CRANpkg{tibble} with
9,364 rows
and fields:
\describe{
\item{projtype}{Projection type (\verb{"ProjectedCoordinateSystems", "GeographicCoordinateSystems","VerticalCoordinateSystems"})}
\item{wkid}{Well-Known ID}
\item{latestWkid}{Most recent \code{wkid}, in case that \code{wkid} is deprecated}
\item{authority}{\code{wkid} authority (Esri or EPSG)}
\item{deprecated}{Logical indicating if \code{wkid} is deprecated}
\item{description}{Human-readable description of the \code{wkid}}
\item{areaname}{Use area of the \code{wkid}}
\item{wkt}{Representation of \code{wkid} in Well-Known Text (WKT). Useful when
working with \CRANpkg{sf} or \CRANpkg{terra}}
}
}
\source{
\href{https://github.com/Esri/projection-engine-db-doc}{ESRI Projection Engine factory}
}
\description{
Database of available spatial references (CRS) in \CRANpkg{tibble} format.
}
\details{
This data base is useful when using the \code{outsr} parameter of the functions.

Some projections ids have changed over time, for example Web Mercator is
\code{wkid  = 102100} is deprecated and currently is \code{wkid = 3857}. However, both
values would work, and they would return similar results.
}
\note{
Data extracted on \strong{14 January 2023}.
}
\examples{
\dontshow{if (arcgeocoder_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
# Get all possible values
data("arc_spatial_references")
arc_spatial_references

# Request with deprecated Web Mercator
library(dplyr)
wkid <- arc_spatial_references \%>\%
  filter(latestWkid == 3857 & deprecated == TRUE) \%>\%
  slice(1)

glimpse(wkid)

add <- arc_geo("London, United Kingdom", outsr = wkid$wkid)

# Note values lat, lon and wkid. latestwkid give the current valid wkid
add \%>\%
  select(lat, lon, wkid, latestWkid) \%>\%
  glimpse()
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=arc_geo_categories]{arc_geo_categories()}}, \code{\link[=arc_geo]{arc_geo()}}, \code{\link[=arc_geo_multi]{arc_geo_multi()}},
\code{\link[=arc_reverse_geo]{arc_reverse_geo()}}.

Other datasets: 
\code{\link{arc_categories}}
}
\concept{datasets}
