% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m1prune.R
\name{prune}
\alias{prune}
\title{Classifier Builder}
\usage{
prune(rules, txns, classitems, default_rule_pruning = TRUE,
  rule_window = 100, greedy_pruning = FALSE, debug = FALSE)
}
\arguments{
\item{rules}{object of class rules from arules package}

\item{txns}{input object with transactions.}

\item{classitems}{a list of items to appear in the consequent (rhs) of the rules.}

\item{default_rule_pruning}{boolean indicating whether default pruning should be performed. If set to TRUE, default pruning is performed as in the CBA algorithm.
If set to FALSE, default pruning is not performed i.e. all rules surviving data coverage pruning are kept. In either case, a default rule is added to the end of the classifier.}

\item{rule_window}{the number of rules to precompute for CBA data coverage pruning. The default value can be adjusted to decrease runtime.}

\item{greedy_pruning}{setting to TRUE activates early stopping condition: pruning will be stopped on first rule on which total error increases.}

\item{debug}{output debug messages.}
}
\value{
Returns an object of class \link{rules}.
}
\description{
An implementation of the CBA-CB M1 algorithm (Liu et al, 1998) adapted for R and arules package apriori implementation in place of CBA-RG.
}
\examples{
 #Example 1
  txns <- as(discrNumeric(datasets::iris, "Species")$Disc.data,"transactions")
  appearance <- getAppearance(datasets::iris,"Species")
  rules <- apriori(txns, parameter = list(confidence = 0.5,
  support= 0.01, minlen= 2, maxlen= 4),appearance = appearance)
  prune(rules,txns, appearance$rhs)
  inspect(rules)

#Example 2
 utils::data(Adult) # this dataset comes with the arules package
 classitems <- c("income=small","income=large")
 rules <- apriori(Adult, parameter = list(supp = 0.3, conf = 0.5,
 target = "rules"), appearance=list(rhs=classitems, default="lhs"))
 # produces 1266 rules
 rules <- prune(rules,Adult,classitems)
 # Rules after data coverage pruning: 198
 # Performing default rule pruning.
 # Final rule list size:  174
}
\references{
Ma, Bing Liu Wynne Hsu Yiming. Integrating classification and association rule mining. Proceedings of the fourth international conference on knowledge discovery and data mining. 1998.
}
\seealso{
\code{\link{topRules}}
}
