% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SoilProfileCollection.R,
%   R/SoilProfileCollection-setters.R
\docType{methods}
\name{restrictions,SoilProfileCollection-method}
\alias{restrictions,SoilProfileCollection-method}
\alias{restrictions}
\alias{restrictions<-}
\alias{restrictions<-,SoilProfileCollection-method}
\title{Get or Set Restriction data in a SoilProfileCollection}
\usage{
\S4method{restrictions}{SoilProfileCollection}(object)

\S4method{restrictions}{SoilProfileCollection}(object) <- value
}
\arguments{
\item{object}{A SoilProfileCollection}

\item{value}{An data.frame object containing at least a column with name \code{idname(object)}}
}
\description{
Restrictions describe root-limiting features in the soil. A single profile may have multiple restrictions.
\itemize{
\item \code{restrictions()} (get method): Get restriction data from a SoilProfileCollection.
}

\itemize{
\item \verb{restrictions<-} (set method): Set restriction data for a SoilProfileCollection. The profile ID column from \code{object} (\code{idname(object)}) must be present in the replacement \code{value} object.
}
}
\examples{

# load test data
data(sp2)

# promote to SPC
depths(sp2) <- id ~ top + bottom

# assign abrupt textural change to a profile
newdata <- data.frame(id = c("hon-21"),
                      restrkind = "abrupt textural change",
                      restrdep = 46)

# do left join
restrictions(sp2) <- newdata

# inspect site table: newvalue TRUE only for horizons
#  with top depth equal to zero
restrictions(sp2)

}
