% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soilColorIndices.R
\name{thompson.bell.darkness}
\alias{thompson.bell.darkness}
\title{Thompson-Bell (1996) Index}
\usage{
thompson.bell.darkness(
  p,
  name = guessHzDesgnName(p, required = TRUE),
  pattern = "^A",
  value = "m_value",
  chroma = "m_chroma"
)
}
\arguments{
\item{p}{A single-profile SoilProfileCollection (e.g. via profileApply())}

\item{name}{Column name containing horizon designations used to find A horizons (default: first column name containing 'name')}

\item{pattern}{Regular expression to match A horizons (default: "^A" which means horizon designation \emph{starts with} A)}

\item{value}{Column name containing horizon color values (default: "m_value")}

\item{chroma}{Column name containing horizon color chromas (default: "m_chroma")}
}
\value{
A numeric vector reflecting horizon darkness (lower values = darker).
}
\description{
Calculate the "Profile Darkness Index" by the method of Thompson & Bell (1996) "Color index for identifying hydric conditions for seasonally saturated mollisols in Minnesota" DOI: 10.2136/sssaj1996.03615995006000060051x. The Thompson-Bell Index has been shown to reflect catenary relationships in some Mollisols of Minnesota (generally: wetter landscape positions = thicker, darker surfaces).
}
\references{
Thompson, J.A. and Bell, J.C. (1996), Color Index for Identifying Hydric Conditions for Seasonally Saturated Mollisols in Minnesota. Soil Science Society of America Journal, 60: 1979-1988. doi:10.2136/sssaj1996.03615995006000060051x
}
\author{
Andrew G. Brown
}
