% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dice.R
\name{dice,SoilProfileCollection-method}
\alias{dice,SoilProfileCollection-method}
\alias{dice}
\title{Efficient Slicing of \code{SoilProfileCollection} Objects}
\usage{
\S4method{dice}{SoilProfileCollection}(
  x,
  fm = NULL,
  SPC = TRUE,
  pctMissing = FALSE,
  fill = FALSE,
  strict = TRUE,
  byhz = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{x}{a \code{SoilProfileCollection} object}

\item{fm}{optional \code{formula} describing top depths and horizon level attributes to include: \code{integer.vector ~ var1 + var2 + var3} or \code{integer.vector ~ .} to include all horizon level attributes. Specification of \code{integer.vector} forces \code{fill = TRUE}. When \code{NULL} profiles are "diced" to depth and results will include all horizon level attributes. Note on interpretation of \code{integer.vector} (slice tops)}

\item{SPC}{return the diced \code{SoilPrfolileCollection}, if \code{FALSE} a \code{data.frame} of horizon-level attributes}

\item{pctMissing}{compute "percent missing data" by slice (when \code{TRUE} expect 6-8x longer run time)}

\item{fill}{logical, fill with empty placeholder horizons in gaps within profiles, and/or, above/below interval specified in \code{fm}. Automatically set to \code{TRUE} when LHS of \code{fm} is specified. Backwards compatibility with \code{slice} is maintained by setting \code{fill = TRUE} with or without \code{fm}.}

\item{strict}{perform horizon depth logic checking / flagging / removal}

\item{byhz}{Evaluate horizon depth logic at the horizon level (\code{TRUE}) or profile level (\code{FALSE}). Invalid depth logic invokes \code{HzDepthLogicSubset} which removes offending profiles or horizon records.}

\item{verbose}{Print information about object size/memory usage. Default: \code{FALSE}}
}
\value{
a \code{SoilProfileCollection} object, or \code{data.frame} when \code{SPC = FALSE}
}
\description{
Cut ("dice") soil horizons into 1-unit thick slices. This function replaces \code{aqp::slice()}, which will be deprecated in aqp 2.0.
}
\details{
For large and potentially messy collections that may include missing horizon depth logic errors, consider using \code{repairMissingHzDepths()} before \code{dice()}. Consider using \code{accumulateDepths()} before invoking \code{dice()} on collections that may contain old-style O horizon notation (e.g. 5-0cm).
}
\seealso{
\code{\link[=repairMissingHzDepths]{repairMissingHzDepths()}}, \code{\link[=accumulateDepths]{accumulateDepths()}}, \code{\link[=fillHzGaps]{fillHzGaps()}}
}
\author{
D.E. Beaudette and A.G. Brown
}
