% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilProfileCollection-metadata.R
\docType{methods}
\name{hztexclname}
\alias{hztexclname}
\alias{hztexclname,SoilProfileCollection-method}
\alias{hztexclname<-}
\alias{hztexclname<-,SoilProfileCollection-method}
\title{Get or Set Horizon Texture Class Column Name}
\usage{
\S4method{hztexclname}{SoilProfileCollection}(object, required = FALSE)

\S4method{hztexclname}{SoilProfileCollection}(object, required = FALSE) <- value
}
\arguments{
\item{object}{a SoilProfileCollection}

\item{required}{logical, is this attribute required? If it is, set to \code{TRUE} to trigger error on invalid \code{value}.}

\item{value}{character, name of column containing horizon texture classes}
}
\description{
\code{hztexclname()}: Get column name containing horizon designation name

\verb{hztexclname<-}: Set horizon texture class column name for a SoilProfileCollection
}
\details{
Store the column name containing horizon texture classes or other identifiers in the metadata slot of the SoilProfileCollection.
}
\examples{

data(sp1)

# promote to SPC
depths(sp1) <- id ~ top + bottom

# set horizon texture class column
hztexclname(sp1) <- "texture"

# get horizon texture class column
hztexclname(sp1)
}
