% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{transform,SoilProfileCollection-method}
\alias{transform,SoilProfileCollection-method}
\alias{mutate}
\alias{mutate,SoilProfileCollection-method}
\title{Transform a SPC with expressions based on site or horizon level attributes}
\usage{
\S4method{transform}{SoilProfileCollection}(`_data`, ...)
}
\arguments{
\item{_data}{A SoilProfileCollection}

\item{...}{Comma-separated set of R expressions e.g. \code{thickness = hzdepb - hzdept, hzdepm = hzdept + round(thk / 2)}}
}
\value{
A SoilProfileCollection
}
\description{
\code{transform()} is a function used for modifying columns in SoilProfileCollections.

It allows the user to specify an arbitrary number of expressions that resolve to the (re-)calculation of one or more site or horizon level attributes. For instance: \code{mutate(spc, thickness = hzdepb - hzdept)}. The expressions may depend on one another, and are evaluated from left to right.
}
\author{
Andrew G. Brown.
}
