% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SoilProfileCollection.R
\docType{methods}
\name{depth_units,SoilProfileCollection-method}
\alias{depth_units,SoilProfileCollection-method}
\alias{depth_units}
\alias{depth_units<-,SoilProfileCollection-method}
\alias{depth_units<-}
\title{Get depth units from metadata}
\usage{
\S4method{depth_units}{SoilProfileCollection}(object)

\S4method{depth_units}{SoilProfileCollection}(object) <- value
}
\arguments{
\item{object}{A SoilProfileCollection}

\item{value}{character, a value representing units. Default \code{'cm'}.}
}
\description{
Get units of depth measurement from metadata. Default value is centimeters.
}
\examples{

data(sp5)

## get depth units
du <- depth_units(sp5)

# set alternate units; e.g. inches
depth_units(sp5) <- 'in'

# replace original value (cm)
depth_units(sp5) <- du

}
