\name{evalGenHZ}
\alias{evalGenHZ}

\title{Evaluate Generalized Horizon Labels}
\description{Data-driven evaluation of generalized horizon labels using nMDS and silhouette width.}
\usage{
evalGenHZ(obj, genhz, vars, non.matching.code = "not-used", 
stand = TRUE, trace = FALSE, metric = "euclidean")
}

\arguments{
  \item{obj}{a \code{SoilProfileCollection} object}
  \item{genhz}{name of horizon-level attribute containing generalized horizon labels}
  \item{vars}{character vector of horizon-level attributes to include in the evaluation}
  \item{non.matching.code}{code used to represent horizons not assigned a generalized horizon label}
  \item{stand}{standardize variables before computing distance matrix (default = TRUE), passed to \code{\link{daisy}}}
  \item{trace}{verbose output from passed to \code{\link{isoMDS}}, (default = FALSE)}
  \item{metric}{distance metric, passed to \code{\link{daisy}}}
}

\details{Non-metric multidimensional scaling is performed via \code{\link{isoMDS}}. The input distance matrix is generated by \code{\link{daisy}} using (complete cases of) horizon-level attributes from \code{obj} as named in \code{vars}.

Silhouette widths are computed via \code{\link{silhouette}}. The input distance matrix is generated by \code{\link{daisy}} using (complete cases of) horizon-level attributes from \code{obj} as named in \code{vars}. Note that observations with genhz labels specified in \code{non.matching.code} are removed filtered before calculation of the distance matrix.
}

\value{a list is returned containing:
\describe{
  \item{horizons}{c('mds.1', 'mds.2', 'sil.width', 'neighbor')}
  \item{stats}{mean and standard deviation of \code{vars}, computed by generalized horizon label}
  \item{dist}{the distance matrix as passed to \code{\link{isoMDS}}}
  }
}

\author{D.E. Beaudette}

\seealso{\code{\link{get.ml.hz}}}

\keyword{manip}

