% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit_apsimx_replacement.R
\name{edit_apsimx_replacement}
\alias{edit_apsimx_replacement}
\title{Edit a replacement component in an .apsimx (JSON) file}
\usage{
edit_apsimx_replacement(
  file = "",
  src.dir = ".",
  wrt.dir = ".",
  node = NULL,
  node.child = NULL,
  node.subchild = NULL,
  node.subsubchild = NULL,
  node.sub3child = NULL,
  node.sub4child = NULL,
  node.sub5child = NULL,
  node.string = NULL,
  root = list("Models.Core.Replacements", NA),
  parm = NULL,
  value = NULL,
  overwrite = FALSE,
  edit.tag = "-edited",
  verbose = TRUE,
  grep.options
)
}
\arguments{
\item{file}{file ending in .apsimx to edit (JSON)}

\item{src.dir}{directory containing the .apsimx file; defaults to the current working directory}

\item{wrt.dir}{should be used if the destination directory is different from the src.dir}

\item{node}{specific node to edit}

\item{node.child}{specific node child component to edit.}

\item{node.subchild}{specific node sub-child to edit.}

\item{node.subsubchild}{specific node sub-subchild to edit.}

\item{node.sub3child}{specific node sub-sub-subchild to edit.}

\item{node.sub4child}{specific node sub-sub-sub-subchild to edit.}

\item{node.sub5child}{specific node sub-sub-sub-sub-subchild to edit.}

\item{node.string}{passing of a string instead of the node hierarchy. It can either start with a dot or not.
However, the \sQuote{best} form is not to start with a dot as it should be a more convenient form of passing
the nodes and their childs and not a real \sQuote{jsonpath}.}

\item{root}{\sQuote{root} node to explore (default = \dQuote{Models.Core.Replacements})}

\item{parm}{specific parameter to edit}

\item{value}{new values for the parameter}

\item{overwrite}{logical; if \code{TRUE} the old file is overwritten, a new file is written otherwise}

\item{edit.tag}{if the file is edited a different tag from the default \sQuote{-edited} can be used.}

\item{verbose}{whether to print information about successful edit}

\item{grep.options}{Additional options for grep. To be passed as a list.}
}
\value{
(when verbose=TRUE) complete file path to edited .apsimx file is returned as a character string.
As a side effect this function creates a new (JSON) .apsimx file.
}
\description{
edit the replacement componenet of an JSON apsimx file. It does not replace the GUI, but it can save time by quickly editing parameters and values.
}
\details{
This is simply a script that prints the relevant parameters which are likely to need editing. It does not print all information from an .apsimx file.
}
\note{
The components that can be edited are restricted becuase this is better in preventing
errors of editing unintended parts of the file.
}
\examples{
\donttest{
extd.dir <- system.file("extdata", package = "apsimx")
## Writing to a temp directory, but change as needed
tmp.dir <- tempdir()

## Inspect original values
inspect_apsimx_replacement("MaizeSoybean.apsimx", 
                           src.dir = extd.dir,
                           node = "Maize", 
                           node.child = "Phenology",
                           node.subchild = "ThermalTime", 
                           node.subsubchild = "BaseThermalTime",
                           node.sub3child = "Response")

edit_apsimx_replacement("MaizeSoybean.apsimx", 
                        src.dir = extd.dir, wrt.dir = tmp.dir,
                        node = "Maize", 
                        node.child = "Phenology",
                        node.subchild = "ThermalTime", 
                        node.subsubchild = "BaseThermalTime",
                        node.sub3child = "Response",
                        parm = "X",
                        value = c(10, 20, 30, 40, 50)) 
## inspect it
inspect_apsimx_replacement("MaizeSoybean-edited.apsimx", 
                           src.dir = tmp.dir,
                           node = "Maize", 
                           node.child = "Phenology",
                           node.subchild = "ThermalTime", 
                           node.subsubchild = "BaseThermalTime",
                           node.sub3child = "Response")

## Illustrating using 'node.string'
## Equivalent to the code to edit above

edit_apsimx_replacement("MaizeSoybean-edited.apsimx", 
                        src.dir = tmp.dir, wrt.dir = tmp.dir,
                        node.string = "Maize.Phenology.ThermalTime.BaseThermalTime.Response",
                        parm = "X",
                        value = c(11, 21, 31, 41, 51),
                        edit.tag = "-ns") 
                        
inspect_apsimx_replacement("MaizeSoybean-edited-ns.apsimx", 
                           src.dir = tmp.dir,
                           node = "Maize", 
                           node.child = "Phenology",
                           node.subchild = "ThermalTime", 
                           node.subsubchild = "BaseThermalTime",
                           node.sub3child = "Response")
}

}
