% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unit_conv.R
\name{unit_conv}
\alias{unit_conv}
\title{performs common unit conversions}
\usage{
unit_conv(x, from, to, ...)
}
\arguments{
\item{x}{input variable}

\item{from}{original units}

\item{to}{target units}

\item{...}{additional arguments passed to specific conversions}
}
\value{
value of the input variable with new units
}
\description{
This function is slowly getting better. Adding more unit conversions as I need them.
}
\details{
Function which performs common unit conversions

At the moment possible conversions are:
\itemize{

\item \sQuote{g/m2} to \sQuote{kg/ha}
\item \sQuote{kg/ha} to \sQuote{g/m2}
\item \sQuote{lb} to \sQuote{kg}
\item \sQuote{kg} to \sQuote{lb}
\item \sQuote{maize bu} to \sQuote{kg}
\item \sQuote{kg} to \sQuote{maize bu}
\item \sQuote{soy bu} to \sQuote{kg}
\item \sQuote{kg} to \sQuote{soy bu}
\item \sQuote{maize bu/ac} to \sQuote{kg/ha}
\item \sQuote{maize bu/ac} to \sQuote{g/m2}
\item \sQuote{kg/ha} to \sQuote{maize bu/ac}
\item \sQuote{g/m2} to \sQuote{maize bu/ac}
\item \sQuote{soy bu/ac} to \sQuote{kg/ha}
\item \sQuote{soy bu/ac} to \sQuote{g/m2}
\item \sQuote{kg/ha} to \sQuote{soy bu/ac}
\item \sQuote{g/m2} to \sQuote{soy bu/ac}
\item \sQuote{mm} to \sQuote{inches}
\item \sQuote{inches} to \sQuote{mm}
\item \sQuote{lb/ac} to \sQuote{kg/ha}
\item \sQuote{kg/ha} to \sQuote{lb/ac}
\item \sQuote{lb/ac} to \sQuote{g/m2}
\item \sQuote{g/m2} to \sQuote{lb/ac}
\item \sQuote{decimal} to \sQuote{degrees}
\item \sQuote{degrees} to \sQuote{decimal}

}

This is for metric and Imperial conversions
Source: https://www.extension.iastate.edu/agdm/wholefarm/html/c6-80.html
}
\examples{
\donttest{
grain.yield.gm2 <- 600
grain.yield.kgha <- unit_conv(grain.yield.gm2, from = "g/m2", to = "kg/ha")
grain.yield.kgha
## Converting coordinates
require(sp)
unit_conv("42d 0' 0\" N", from = "degrees", to = "decimal")
unit_conv(42, from = "decimal", to = "degrees") ## EW by default
unit_conv(42, from = "decimal", to = "degrees", NS = TRUE)
}

}
