% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view_apsimx.R
\name{view_apsim}
\alias{view_apsim}
\title{Viewing an APSIM Classic file interactively}
\usage{
view_apsim(file, src.dir, viewer = c("json", "react"), ...)
}
\arguments{
\item{file}{a file ending in .apsim to be inspected (XML)}

\item{src.dir}{directory containing the .apsim file to be inspected; defaults to the current working directory}

\item{viewer}{either \dQuote{json} or \dQuote{react}.}

\item{...}{additional arguments passed to either \sQuote{jsonedit} or \sQuote{reactjson}.
These are functions in package \CRANpkg{listviewer}.}
}
\value{
a display with the APSIM file structure.
}
\description{
Generate an interactive viewer for an APSIM file
}
\note{
I do not know how to edit an APSIM file using this method yet.
}
\examples{
\donttest{
extd.dir <- system.file("extdata", package = "apsimx")
## View the structure of the APSIM-X simulation file
view_apsim("Millet.apsim", src.dir = extd.dir)
}

}
