% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apsimx.R
\name{apsimx_example}
\alias{apsimx_example}
\title{Access Example APSIM-X Simulations}
\usage{
apsimx_example(example = "Wheat", silent = FALSE)
}
\arguments{
\item{example}{run an example from built-in APSIM-X. Options are all of the ones included with the APSIM-X distribution, except \sQuote{Graph}.}

\item{silent}{whether to print standard output from the APSIM-X execution}
}
\description{
simple function to run some of the built-in APSIM-X examples
}
\details{
This function creates a temporary copy of the example file distributed with APSIM-X to avoid writing a .db file 
         to the directory where the \sQuote{Examples} are located. It is not a good practice and there is no guarantee that 
         the user has read/write permissions in that directory.
}
\note{
This function creates a new column \sQuote{Date} which is in the R \sQuote{Date} format which is convenient for graphics.
}
\examples{
\dontrun{
wheat <- apsimx_example("Wheat")
maize <- apsimx_example("Maize")
barley <- apsimx_example("Barley")
## The 'Date' column is created by this function, based on apsim output.
require(ggplot2)
ggplot(data = wheat , aes(x = Date, y = Yield)) + 
  geom_point()
}

}
