% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strategy.R
\name{strategy}
\alias{strategy}
\title{An Accessory Function for Strategy Selection}
\usage{
strategy(g, method, int, int.adj, model)
}
\arguments{
\item{g}{a data matrix to which a modelling strategy will be applied.}

\item{method}{a list containing the a regression modelling strategy name
and strategy-specific parameter values.}

\item{int}{logical. If int is TRUE an intercept will be included in the
regression model.}

\item{int.adj}{logical. If int.adj is TRUE the intercept will be re-estimated
after shrinkage is applied to the regression coefficients.}

\item{model}{the type of regression model. Either "linear" or "logistic".}
}
\value{
The object returned by \code{strategy} depends on the strategy selected in the
        call to \code{compare}. For example, if \code{method[1] = "lsq"}, \code{strategy} will return
        a matrix of regression coefficients, whereas if \code{method[1] = "boot"}, strategy
        will return a list containing values returned by \code{bootval}.
}
\description{
This function acts as a switchboard for various regression modelling strategy,
and links these strategies to \code{\link{compare}}.
}
\details{
For further details, see \code{\link{compare}}.
}
\note{
This function is not designed to be called directly, but acts as a workhorse
     function for \code{compare}
}

