% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_attach.R
\name{apollo_attach}
\alias{apollo_attach}
\title{Attaches predefined variables.}
\usage{
apollo_attach(apollo_beta, apollo_inputs)
}
\arguments{
\item{apollo_beta}{Named numeric vector. Names and values for parameters.}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}
}
\value{
Nothing.
}
\description{
Attaches parameters and data to allow users to refer to individual variables by name without reference to the object that contains them. Also applies scaling if in use.
}
\details{
This function should be called at the beginning of \code{apollo_probabilities}
to make writing the log-likelihood more user-friendly. If used, then \link{apollo_detach}
should be called at the end \code{apollo_probabilities}, or more conveniently, 
using \link{on.exit}.
\code{apollo_attach} attaches \code{apollo_beta}, \code{database}, \code{draws},
and the output of \code{apollo_randCoeff} and \code{apollo_lcPars}, if they are
defined by the user. The use of \code{apollo_attach} is mandatory in models using scaling.
}
