% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_validateControl.R
\name{apollo_validateControl}
\alias{apollo_validateControl}
\title{Validates apollo_control}
\usage{
apollo_validateControl(database, apollo_control, silent = FALSE)
}
\arguments{
\item{database}{data.frame. Data used by model.}

\item{apollo_control}{List. Options controlling the running of the code.
\itemize{
  \item \code{modelName}: Character. Name of the model. Used when saving the output to files.
  \item \code{modelDescr}: Character. Description of the model. Used in output files.
  \item \code{indivID}: Character. Name of column in the database with each decision maker's ID.
  \item \code{mixing}: Boolean. TRUE for models that include random parameters.
  \item \code{nCores}: Numeric>0. Number of cores to use in calculations of the model likelihood.
  \item \code{seed}: Numeric. Seed for random number generation.
  \item \code{HB}: Boolean. TRUE if using RSGHB for Bayesian estimation of model.
  \item \code{noValidation}: Boolean. TRUE if user does not wish model input to be validated before estimation - FALSE by default.
  \item \code{noDiagnostics}: Boolean. TRUE if user does not wish model diagnostics to be printed - FALSE by default.
  \item \code{weights}: Character. Name of column in database containing weights for estimation.
  \item \code{workInLogs}: Boolean. TRUE for increased numeric precision in models with panel data - FALSE by default.
  \item \code{panelData}: Boolean. TRUE if there are multiple obsrvations (i.e. rows) for each decision maker - Automatically set based on \code{indivID} by default.
}}

\item{silent}{Boolean. If TRUE, no messages are printed to screen.}
}
\value{
Validated version of apollo_control, with additional element called panelData set to TRUE for repeated choice data.
}
\description{
Validates the options controlling the running of the code \code{apollo_control} and sets default values for the omitted ones.
}
\details{
This function should be run before running \code{apollo_validateData}.
}
