% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_validateHBControl.R
\name{apollo_validateHBControl}
\alias{apollo_validateHBControl}
\title{Validates the apollo_HB list of parameters}
\usage{
apollo_validateHBControl(apollo_HB, apollo_beta, apollo_fixed,
  apollo_control)
}
\arguments{
\item{apollo_HB}{List. Contains options for bayesian estimation. See \code{?RSGHB::doHB} for details.
Parameters \code{modelname}, \code{gVarNamesFixed}, \code{gVarNamesNormal},
\code{gDIST}, \code{svN} and \code{FC} are automatically set based on the
other arguments of this function.
It should also include a named character vector called \code{hbDist} identifying 
the distribution of each parameter to be estimated. Possible values are as follows.
\itemize{
  \item "DNE": Parameter kept at its starting value (not estimated).
  \item "F": Fixed (as in non-random) parameter.
  \item "N": Normal.
  \item "LN+": Positive log-normal.
  \item "LN-": Negative log-normal.
  \item "CN+": Positive censored normal.
  \item "CN-": Negative censored normal.
  \item "JSB": Johnson SB.
}}

\item{apollo_beta}{Named numeric vector. Names and values for parameters.}

\item{apollo_fixed}{Character vector. Names (as defined in \code{apollo_beta}) of parameters whose value should not change during estimation.
value is constant throughout estimation).}

\item{apollo_control}{List. Options controlling the running of the code. See \link{apollo_validateInputs}.}
}
\value{
Validated apollo_HB
}
\description{
Validates the apollo_HB list of parameters and sets default values for the omitted ones.
}
\details{
This function is only necessary when using bayesian estimation.
}
