% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_splitDataDraws.R
\name{apollo_splitDataDraws}
\alias{apollo_splitDataDraws}
\title{Splits data and draws for loading in cluster}
\usage{
apollo_splitDataDraws(apollo_control, database, draws = NA,
  silent = FALSE)
}
\arguments{
\item{apollo_control}{List. Contains options for the estimation. See \link{apollo_validatecontrol}.}

\item{database}{data.frame. Estimation data.}

\item{draws}{List. Draws as created by \link{apollo_makeDraws}.}

\item{silent}{Boolean. If TRUE, no information is printed to console or default output.}
}
\value{
List. Each element is a list containing two elements:
        a fraction of the database and a fraction of the draws (if given).
}
\description{
Splits the database and the draws (if given) in a list with as many elements as apollo_control$nCores.
}
\details{
Internal use only. This function is called by \link{apollo_makeCluster}.
}
