% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upset.R
\name{upset_plot}
\alias{upset_plot}
\title{upsetplot2}
\usage{
upset_plot(
  list,
  nintersects = NULL,
  order.intersect.by = c("size", "name"),
  order.set.by = c("size", "name")
)
}
\arguments{
\item{list}{a list of sets}

\item{nintersects}{number of intersects. If NULL, all intersections will show.}

\item{order.intersect.by}{one of 'size' or 'name'}

\item{order.set.by}{one of 'size' or 'name'}
}
\value{
an upset plot
}
\description{
Plot a upset plot
}
\details{
This function generate a upset plot by creating a composite plot which contains subplots generated by ggplot2.
}
\examples{
 list = list(A = sample(LETTERS, 20),
             B = sample(LETTERS, 22),
             C = sample(LETTERS, 14),
             D = sample(LETTERS, 30, replace = TRUE))
 upset_plot(list)
 upset_plot(list, order.intersect.by = "name")
 upset_plot(list, nintersects = 6)
}
