% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{readPHMM}
\alias{readPHMM}
\title{Import profile hidden Markov models into R.}
\usage{
readPHMM(file = "", ...)
}
\arguments{
\item{file}{the name of the file from which to read the model.}

\item{...}{further arguments to be passed to \code{"scan"}.}
}
\value{
an object of class \code{"PHMM"}.
}
\description{
The \code{readPHMM} function parses a HMMER3 text file into R and creates
  an object of class \code{"PHMM"}.
}
\details{
This function scans a HMMER3/f text file and creates an object of
  class \code{"PHMM"} in R. Note that unlike HMMER, the \pkg{aphid}
  package does not currently support position-specific background
  emission probabilities, and so only a single vector the same length
  as the reside alphabet is included as an element of the returned
  object. Also the function currently only parses the first profile
  HMM encountered in the text file, with subsequent models ignored.
}
\examples{
  ## Derive a profile hidden Markov model from the small globin alignment
  data(globins)
  x <- derivePHMM(globins, residues = "AMINO", seqweights = NULL)
  fl <- tempfile()
  writePHMM(x, file = fl)
  readPHMM(fl)
}
\references{
Finn RD, Clements J & Eddy SR (2011) HMMER web server: interactive sequence
  similarity searching. \emph{Nucleic Acids Research}. \strong{39}, W29-W37.
  \url{http://hmmer.org/}.

  HMMER: biosequence analysis using profile hidden Markov models.
  \url{http://www.hmmer.org}.
}
\seealso{
\code{\link{writePHMM}} for writing PHMM objects in HMMER3 text format.
}
\author{
Shaun Wilkinson
}
