% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-options.R
\name{heatmap_opts}
\alias{heatmap_opts}
\title{Heatmap options}
\usage{
heatmap_opts(
  radius = NULL,
  enableShades = NULL,
  shadeIntensity = NULL,
  colorScale = NULL,
  ...
)
}
\arguments{
\item{radius}{Numeric. Radius of the rectangle inside heatmap.}

\item{enableShades}{Logical. Enable different shades of color depending on the value}

\item{shadeIntensity}{Numeric \code{[0,1]}. The intensity of the shades generated for each value.}

\item{colorScale}{List.}

\item{...}{Additional parameters.}
}
\value{
A \code{list} of options that can be used in \code{\link[=ax_plotOptions]{ax_plotOptions()}}.
}
\description{
Use these options in \code{\link[=ax_plotOptions]{ax_plotOptions()}}.
}
\note{
See \url{https://apexcharts.com/docs/options/plotoptions/heatmap/}.
}
\examples{

df <- expand.grid(
  month = month.name,
  person = c("Obi-Wan", "Luke", "Anakin", "Leia")
)
df$value <- sample(0:1, nrow(df), TRUE)

apex(
  data = df,
  mapping = aes(x = month, y = person, fill = value),
  type = "heatmap"
) \%>\% 
  ax_plotOptions(
    heatmap = heatmap_opts(
      enableShades = FALSE,
      colorScale = list(
        ranges = list(
          list(from = 0, to = 0.5, color = "#FF0000"),
          list(from = 0.5, to = 1, color = "#088A08")
        )
      )
    )
  )
  
}
