% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_interface.R
\name{sedona_read_geojson_to_typed_rdd}
\alias{sedona_read_geojson_to_typed_rdd}
\title{Create a typed SpatialRDD from a GeoJSON data source.}
\usage{
sedona_read_geojson_to_typed_rdd(
  sc,
  location,
  type = c("point", "polygon", "linestring"),
  has_non_spatial_attrs = TRUE,
  storage_level = "MEMORY_ONLY",
  repartition = 1L
)
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{location}{Location of the data source.}

\item{type}{Type of the SpatialRDD (must be one of "point", "polygon", or
"linestring".}

\item{has_non_spatial_attrs}{Whether the input contains non-spatial
attributes.}

\item{storage_level}{Storage level of the RDD (default: MEMORY_ONLY).}

\item{repartition}{The minimum number of partitions to have in the resulting
RDD (default: 1).}
}
\value{
A typed SpatialRDD.
}
\description{
Create a typed SpatialRDD (namely, a PointRDD, a PolygonRDD, or a
LineStringRDD) from a GeoJSON data source.
}
\examples{
library(sparklyr)
library(apache.sedona)

sc <- spark_connect(master = "spark://HOST:PORT")

if (!inherits(sc, "test_connection")) {
  input_location <- "/dev/null" # replace it with the path to your input file
  rdd <- sedona_read_geojson_to_typed_rdd(
    sc,
    location = input_location, type = "polygon"
  )
}

}
\seealso{
Other Sedona data inferface functions: 
\code{\link{sedona_read_dsv_to_typed_rdd}()},
\code{\link{sedona_read_geojson}()},
\code{\link{sedona_read_shapefile_to_typed_rdd}()},
\code{\link{sedona_read_shapefile}()},
\code{\link{sedona_read_wkb}()},
\code{\link{sedona_read_wkt}()},
\code{\link{sedona_save_spatial_rdd}()},
\code{\link{sedona_write_geojson}()},
\code{\link{sedona_write_wkb}()},
\code{\link{sedona_write_wkt}()}
}
\concept{Sedona data inferface functions}
