% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aoristic.datacheck.R
\name{aoristic.datacheck}
\alias{aoristic.datacheck}
\title{Check aoristic input data}
\usage{
aoristic.datacheck(data1, Xcoord, Ycoord, DateTimeFrom, DateTimeTo)
}
\arguments{
\item{data1}{data.frame with a minimum of 4 columns with X, Y coords, Start and End date/time}

\item{Xcoord}{a vector of the X coordinate or latitude (numeric object)}

\item{Ycoord}{a vector of the Y coordinate or longitude (numeric object)}

\item{DateTimeFrom}{a  vector of the column name for FromDateTime (POSIXct date-time object)}

\item{DateTimeTo}{a vector of the column name for ToDateTime (POSIXct date-time object)}
}
\value{
A data frame flagging any problems or logical errors from an aoristic data check
}
\description{
A function that flags datetime errors with aoristic input data.
}
\details{
The aoristic.df function handles data with Start (or From) and End (or To) datetime objects. Sometimes
these data can be messy or inaccurately recorded (such as crime data from some police departments). This
function checks for common problems and reports the result in a column labeled 'aoristic_datacheck'.

Rows with missing 'End' information are flagged with '1' and counted in the console.
Rows where the 'End' datetime occurs before the 'Start' datetime are flagged '2'. 

Note that aoristic.df() will still run even with the data issues. Where the 'End'
datetime is missing, the aoristic value will be assigned to the 'Start' datetime hour.
When the 'End' datetime comes before the 'Start' datetime, the 'Start' datetime is only used
and again, the aoristic value is assigned to the 'Start' datetime hour.
}
\examples{
datacheck.df <- aoristic.datacheck(dcburglaries, 'X', 'Y', 'StartDateTime', 'EndDateTime')
}
\references{
Ratcliffe, J. H. (2002). Aoristic signatures and the spatio-temporal analysis of high volume crime patterns. Journal of Quantitative Criminology, 18(1), 23-43.
}
