% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_planes.R
\name{get_planes}
\alias{get_planes}
\title{Query nycflights13-Like Planes Data}
\source{
FAA Aircraft registry,
 \url{https://www.faa.gov/licenses_certificates/aircraft_certification/aircraft_registry/releasable_aircraft_download}
}
\usage{
get_planes(year, dir = NULL, flights_data = NULL)
}
\arguments{
\item{year}{A numeric giving the year of interest. This argument is currently
not vectorized, as dataset sizes for single years are significantly large.
Information for the most recent year is usually available by February or 
March in the following year.}

\item{dir}{An optional character string giving the directory
to save datasets in. By default, datasets will not be saved to file.}

\item{flights_data}{Optional---either a filepath as a 
character string or a dataframe outputted by \code{\link{get_flights}} that
will be used to subset the output to only include relevant carriers/planes.
If not supplied, all carriers/planes will be returned.}
}
\value{
A data frame with ~3500 rows and 9 variables:
\describe{
\item{tailnum}{Tail number}
\item{year}{Year manufactured}
\item{type}{Type of plane}
\item{manufacturer, model}{Manufacturer and model}
\item{engines, seats}{Number of engines and seats}
\item{speed}{Average cruising speed in mph}
\item{engine}{Type of engine}
}
}
\description{
This function generates a dataframe similar to the 
\code{\link[nycflights13]{planes}} dataset from \code{nycflights13} 
for any US airports and time frame. Please 
note that, even with a strong internet connection, this function 
may take several minutes to download relevant data.
}
\examples{

# grab airplanes data for 2018
\donttest{\dontrun{get_planes(2018)}}

# if you'd like to only return the planes that appear 
# in \code{flights}, query your flights dataset first, 
# and then supply it as a \code{flights_data} argument
\donttest{\dontrun{get_planes(2018, 
                 flights_data = get_flights("PDX", 2018, 6))}}

}
\seealso{
\code{\link{get_flights}} for flight data,
\code{\link{get_weather}} for weather data, 
\code{\link{get_airlines}} for airlines data,
\code{\link{get_airports}} for airports data,
or \code{\link{anyflights}} for a wrapper function.

Use the \code{\link{as_flights_package}} function to convert this dataset 
to a data-only package.
}
