% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.antaresData}
\alias{plot.antaresData}
\title{plot time series contained in an antaresData object}
\usage{
\method{plot}{antaresData}(x, y = NULL, table = NULL, variable = NULL,
  elements = NULL, mcYear = "average", type = c("ts", "barplot",
  "monotone", "density", "cdf", "heatmap"), dateRange = NULL, confInt = 0,
  minValue = NULL, maxValue = NULL, aggregate = c("none", "mean", "sum"),
  compare = NULL, compareLayout = c("v", "h"),
  interactive = getInteractivity(), colors = NULL, main = NULL,
  ylab = NULL, legend = TRUE, legendItemsPerRow = 5,
  colorScaleOpts = colorScaleOptions(20), width = NULL, height = NULL,
  ...)
}
\arguments{
\item{x}{Object of class \code{antaresData}.}

\item{y}{Optional object of class \code{antaresData}. If it is specified, then two
charts are generated.}

\item{table}{Name of the table to display when \code{x} is an \code{antaresDataList}
object.}

\item{variable}{Name of the variable to plot. If this argument is missing, then the 
function starts a shiny gadget that let the user choose the variable to
represent. When the user clicks on the "Done" button", the graphic is
returned by the function.}

\item{elements}{Vector of "element" names indicating for which elements of 'x' should the
variable be plotted. For instance if the input data contains areas, then
this parameter should be a vector of area names. If data contains clusters
data, this parameter has to be the concatenation of the area name and the
cluster name, separated by \code{" > "}. This is to prevent confusion 
when two clusters from different areas have the same name.}

\item{mcYear}{If \code{x}, contains multiple Monte-Carlo scenarios, this parameter 
determine which scenario is displayed. Must be an integer representing the
index of the scenario or the word "average". In this case data are 
averaged.}

\item{type}{Type of plot to draw. "ts" creates a time series plot, "barplot" creates
a barplot with one bar per element representing the average value of the
variable for this element. "monotone" draws the monotone curve of the 
variable for each element.}

\item{dateRange}{A vector of two dates. Only data points between these two dates are 
displayed. If NULL, then all data is displayed.}

\item{confInt}{Number between 0 and 1 indicating the size of the confidence interval to 
display. If it equals to 0, then confidence interval is not computed nor
displayed. Used only when multiple Monte Carlo scenarios are present in 
the input data.}

\item{minValue}{Only used if parameter \code{type} is "density" or "cdf". If this parameter
is set, all values that are less than \code{minValue} are removed from the 
graphic. This is useful to deal with variables containing a few extreme
values (generally cost and price variables). If \code{minValue} is unset,
all values are displayed.}

\item{maxValue}{Only used if parameter \code{type} is "density" or "cdf". If this parameter 
is set, all values not in [-minValue, maxValue] are removed from the graphic.
This is useful to deal with variables containing a few extreme values
(generally cost and price variables). If \code{maxValue} is 0 or unset, all
values are displayed.}

\item{aggregate}{When multiple elements are selected, should the data be aggregated. If
"none", each element is represented separetly. If "mean" values are
averaged and if "sum" they are added.}

\item{compare}{An optional character vector containing names of parameters. When it is set,
two charts are outputed with their own input controls. Alternatively, it can
be a named list with names corresponding to parameter names and values being
list with the initial values of the given parameter for each chart.}

\item{compareLayout}{Only used if \code{y} or \code{compare} is not null. If it equals to "v", 
then charts are placed one above the other. If it equals to "h", they are
placed one next to the other.}

\item{interactive}{LogicalValue. If \code{TRUE}, then a shiny gadget is launched that lets
the user interactively choose the areas or districts to display.}

\item{colors}{Vector of colors}

\item{main}{Title of the graph.}

\item{ylab}{Label of the Y axis.}

\item{legend}{Logical value indicating if a legend should be drawn. This argument is 
usefull when one wants to create a shared legend with
\code{\link{prodStackLegend}}}

\item{legendItemsPerRow}{Number of elements to put in each row of the legend.}

\item{colorScaleOpts}{A list of parameters that control the creation of color scales. It is used
only for heatmaps. See \code{\link{colorScaleOptions}}() for available
parameters.}

\item{width}{Width of the graph expressed in pixels or in percentage of 
the parent element. For instance "500px" and "100\%" are valid values.}

\item{height}{Height of the graph expressed in pixels or in percentage of 
the parent element. For instance "500px" and "100\%" are valid values.}

\item{...}{currently unused}
}
\value{
The function returns an object of class "htmlwidget". It is generated by
package \code{highcharter} if time step is annual or by \code{dygraphs} for 
any other time step.It can be directly displayed in the viewer or be stored
in a variable for later use.
}
\description{
This function generates an interactive plot of an antares time series.
}
\details{
If the input data contains several Monte-Carlo scenarios, the function will
display the evolution of the average value. Moreover it will represent a
95% confidence interval.

If the input data has a annual time step, the function creates a barplot
instead of a line chart.
}
\examples{
\dontrun{
setSimulationPath()
mydata <- readAntares("all", timeStep = "monthly")
plot(mydata)
plot(mydata, "LOAD")

# Plot only a few areas
plot(mydata[area \%in\% c("area1", "area2", "area3")])

# If data contains detailed results, then the function adds a confidence
# interval
dataDetailed <- readAntares("all", timeStep = "monthly", synthesis = FALSE)
plot(dataDetailed)

# If the time step is annual, the function creates a barplot instead of a
# linechart
dataAnnual <- readAntares("all", timeStep = "Annual")
plot(dataAnnual)

# Compare the results of two simulations
setSimulationPath(path1)
mydata1 <- readAntares("all", timeStep = "daily")
setSimulationPath(path2)
mydata2 <- readAntares("all", timeStep = "daily")

plot(mydata1, mydata2)

# Compare two periods for the same simulation
plot(mydata1, compare = "dateRange")

# Compare two Monte-Carlo scenarios
detailedData <- readAntares("all", mcYears = "all")
plot(detailedData[mcYear == 1], detailedData[mcYear == 2])

# To do the same thing, with antaresDataList objects, one can use 'subset'
detailedData <- readAntares(areas = "all" links = "all", mcYears = "all")
plot(subset(detailedData, mcYears = 1), subset(detailedData, mcYears = 2))
}

}
