% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_layout.R
\name{mapLayout}
\alias{mapLayout}
\title{Place areas of a study on a map}
\usage{
mapLayout(layout, what = c("areas", "districts"), map = getSpMaps(),
  map_builder = TRUE)
}
\arguments{
\item{layout}{object returned by function \code{\link[antaresRead]{readLayout}}}

\item{what}{Either "areas" or "districts". Indicates what type of object to place
on the map.}

\item{map}{An optional \code{\link[sp]{SpatialPolygons}} or 
\code{\link[sp]{SpatialPolygonsDataFrame}} object. See \code{\link[spMaps]{getSpMaps}}}

\item{map_builder}{\code{logical} Add inputs for build custom map ? Defaut to TRUE.}
}
\value{
An object of class \code{mapLayout}.
}
\description{
This function launches an interactive application that let the user place 
areas of a study on a map. the GPS coordinates of the areas are then returned
and can be used in functions. This function should be used only once per 
study. The result should then be saved in an external file and be reused.
}
\details{
With \code{map_builder} option, you can build a quiet custom map using \code{spMaps} package. 
This package help you to build \code{\link[sp]{SpatialPolygonsDataFrame}} on Europe. 
Moreover, you can use two options in the module : 

\itemize{
   \item {"Merge countries" : Some countries like UK or Belgium are firstly rendered in multiple and diffrent area. 
   You can so choose to finally use this countries as one single area on the map}
   \item {"Merge states" : If you need states details but not having one area per state, the map will be incomplete 
   for some countries, plotting only states with area. So you can choose to aggregate the states of the countries.
   This is done using a nearest states algorithm. The result is available only after layout validation.}
 }
}
\examples{
\dontrun{
# Read the coordinates of the areas in the Antares interface, then convert it
# in a map layout.
layout <- readLayout()
ml <- mapLayout(layout)

# visualize mapLayout
plotMapLayout(ml)

# Save the result for future use
save(ml, file = "ml.rda")

}

}
\seealso{
\code{\link{plotMapLayout}}
}
