% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_storage.R
\name{clean_store_batch}
\alias{clean_store_batch}
\title{Cleans a directory of animal data files and stores them locally in rds format}
\usage{
clean_store_batch(
  data_info,
  filters = TRUE,
  zoom = 11,
  get_slope = TRUE,
  get_aspect = TRUE,
  min_lat = data_info$min_lat,
  max_lat = data_info$max_lat,
  min_long = data_info$min_long,
  max_long = data_info$max_long,
  tz_in = "UTC",
  tz_out = "UTC"
)
}
\arguments{
\item{data_info}{list of animal data frames with information about the data, generated by store_batch}

\item{filters}{filter bad data points, defaults to true}

\item{zoom}{level of zoom, defaults to 11}

\item{get_slope}{logical, whether to compute slope (in degrees), defaults to true}

\item{get_aspect}{logical, whether to compute aspect (in degrees), defaults to true}

\item{min_lat}{minimum latitude for filtering, defaults to min in data_info}

\item{max_lat}{maximum latitude for filtering, defaults to max in data_info}

\item{min_long}{minimum longitude for filtering, defaults to min in data_info}

\item{max_long}{maximum longitude for filtering, defaults to max in data_info}

\item{tz_in}{input time zone, defaults to UTC}

\item{tz_out}{output time zone, defaults to UTC}
}
\value{
df of metadata for animal file directory
}
\description{
Cleans a directory of animal data files and stores them locally in rds format
}
