% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_cleaning.R
\name{clean_location_data}
\alias{clean_location_data}
\title{Cleans a raw animal GPS dataset, implementing a standardized procedure to remove impossible values}
\usage{
clean_location_data(
  df,
  dtype,
  filters = TRUE,
  aniid = NA,
  gpsid = NA,
  maxrate = 84,
  maxcourse = 100,
  maxdist = 840,
  maxtime = 100,
  tz_in = "UTC",
  tz_out = "UTC"
)
}
\arguments{
\item{df}{data frame in standardized format (e.g., from a raw spreadsheet)}

\item{dtype}{data type, iGotU or Columbus P-1}

\item{filters}{filter bad data points, defaults to true}

\item{aniid}{identification code for the animal}

\item{gpsid}{identification code for the GPS device}

\item{maxrate}{maximum rate of travel (meters/minute) between consecutive points}

\item{maxcourse}{maximum distance (meters) between consecutive points}

\item{maxdist}{maximum geographic distance (meters) between consecutive points}

\item{maxtime}{maximum time (minutes) between consecutive points}

\item{tz_in}{input time zone, defaults to UTC}

\item{tz_out}{output time zone, defaults to UTC}
}
\value{
df of clean animal GPS data
}
\description{
Cleans a raw animal GPS dataset, implementing a standardized procedure to remove impossible values
}
\examples{
# Clean a data frame from csv

## Read igotU data
bannock_df <- read.csv(system.file("extdata", "demo_nov19/Bannock_2017_101_1149.csv", 
package = "animaltracker"), skipNul=TRUE)

## Clean and filter
clean_location_data(bannock_df, dtype = "igotu", filters = TRUE, aniid = 1149, 
gpsid = 101, maxrate = 84, maxdist = 840, maxtime = 100)

## Clean without filtering
clean_location_data(bannock_df, dtype = "igotu", filters = FALSE, aniid = 1149, 
gpsid = 101, maxrate = 84, maxdist = 840, maxtime = 100)

# Clean a data frame from txt

## Read Columbus P-1 data
columbus_df <- read_columbus(system.file("extdata", "demo_columbus.TXT", 
package = "animaltracker"))

## Clean and filter
clean_location_data(columbus_df, dtype = "columbus", filters = TRUE, aniid = 1149, 
gpsid = 101, maxrate = 84, maxdist = 840, maxtime = 100)
}
