# These tests include all letters that could trigger special handling in native
# Italian, Spanish and Welsh words

test_that("handling accents without stringi or iconv", {
  mockery::stub(normalize, "rlang::is_installed", FALSE)
  mockery::stub(normalize, "iconv", NA)

  expect_true(grepl("^[^A-Za-z]*a", normalize("á")))
  expect_true(grepl("^[^A-Za-z]*a", normalize("à")))
  expect_true(grepl("^[^A-Za-z]*a", normalize("â")))
  expect_true(grepl('^[^A-Za-z]*a', normalize("ä")))
  expect_true(grepl("^[^A-Za-z]*e", normalize("é")))
  expect_true(grepl("^[^A-Za-z]*e", normalize("è")))
  expect_true(grepl("^[^A-Za-z]*e", normalize("ê")))
  expect_true(grepl("^[^A-Za-z]*e", normalize("ë")))
  expect_true(grepl("^[^A-Za-z]*i", normalize("í")))
  expect_true(grepl("^[^A-Za-z]*i", normalize("ì")))
  expect_true(grepl("^[^A-Za-z]*i", normalize("î")))
  expect_true(grepl("^[^A-Za-z]*i", normalize("ï")))
  expect_true(grepl("^[^A-Za-z]*o", normalize("ó")))
  expect_true(grepl("^[^A-Za-z]*o", normalize("ò")))
  expect_true(grepl("^[^A-Za-z]*o", normalize("ô")))
  expect_true(grepl("^[^A-Za-z]*o", normalize("ö")))
  expect_true(grepl("^[^A-Za-z]*u", normalize("ú")))
  expect_true(grepl("^[^A-Za-z]*u", normalize("ù")))
  expect_true(grepl("^[^A-Za-z]*u", normalize("û")))
  expect_true(grepl("^[^A-Za-z]*u", normalize("ü")))
  expect_true(grepl("^[^A-Za-z]*w", normalize("ẃ")))
  expect_true(grepl("^[^A-Za-z]*w", normalize("ẁ")))
  expect_true(grepl("^[^A-Za-z]*w", normalize("ŵ")))
  expect_true(grepl("^[^A-Za-z]*w", normalize("ẅ")))
  expect_true(grepl("^[^A-Za-z]*y", normalize("ý")))
  expect_true(grepl("^[^A-Za-z]*y", normalize("ỳ")))
  expect_true(grepl("^[^A-Za-z]*y", normalize("ŷ")))
  expect_true(grepl("^[^A-Za-z]*y", normalize("ÿ")))

  expect_true(grepl("^[^A-Za-z]*a", normalize("Á")))
  expect_true(grepl("^[^A-Za-z]*a", normalize("À")))
  expect_true(grepl("^[^A-Za-z]*a", normalize("Â")))
  expect_true(grepl("^[^A-Za-z]*a", normalize("Ä")))
  expect_true(grepl("^[^A-Za-z]*e", normalize("É")))
  expect_true(grepl("^[^A-Za-z]*e", normalize("È")))
  expect_true(grepl("^[^A-Za-z]*e", normalize("Ê")))
  expect_true(grepl("^[^A-Za-z]*e", normalize("Ë")))
  expect_true(grepl("^[^A-Za-z]*i", normalize("Í")))
  expect_true(grepl("^[^A-Za-z]*i", normalize("Ì")))
  expect_true(grepl("^[^A-Za-z]*i", normalize("Î")))
  expect_true(grepl("^[^A-Za-z]*i", normalize("Ï")))
  expect_true(grepl("^[^A-Za-z]*o", normalize("Ó")))
  expect_true(grepl("^[^A-Za-z]*o", normalize("Ò")))
  expect_true(grepl("^[^A-Za-z]*o", normalize("Ô")))
  expect_true(grepl("^[^A-Za-z]*o", normalize("Ö")))
  expect_true(grepl("^[^A-Za-z]*u", normalize("Ú")))
  expect_true(grepl("^[^A-Za-z]*u", normalize("Ù")))
  expect_true(grepl("^[^A-Za-z]*u", normalize("Û")))
  expect_true(grepl("^[^A-Za-z]*u", normalize("Ü")))
  expect_true(grepl("^[^A-Za-z]*w", normalize("Ẃ")))
  expect_true(grepl("^[^A-Za-z]*w", normalize("Ẁ")))
  expect_true(grepl("^[^A-Za-z]*w", normalize("Ŵ")))
  expect_true(grepl("^[^A-Za-z]*w", normalize("Ẅ")))
  expect_true(grepl("^[^A-Za-z]*y", normalize("Ý")))
  expect_true(grepl("^[^A-Za-z]*y", normalize("Ỳ")))
  expect_true(grepl("^[^A-Za-z]*y", normalize("Ŷ")))
  expect_true(grepl("^[^A-Za-z]*y", normalize("Ÿ")))
})

test_that("handling accents without stringi", {
  mockery::stub(normalize, "rlang::is_installed", FALSE)

  expect_true(grepl("^[^A-Za-z]*a", normalize("á")))
  expect_true(grepl("^[^A-Za-z]*a", normalize("à")))
  expect_true(grepl("^[^A-Za-z]*a", normalize("â")))
  expect_true(grepl('^[^A-Za-z]*a', normalize("ä")))
  expect_true(grepl("^[^A-Za-z]*e", normalize("é")))
  expect_true(grepl("^[^A-Za-z]*e", normalize("è")))
  expect_true(grepl("^[^A-Za-z]*e", normalize("ê")))
  expect_true(grepl("^[^A-Za-z]*e", normalize("ë")))
  expect_true(grepl("^[^A-Za-z]*i", normalize("í")))
  expect_true(grepl("^[^A-Za-z]*i", normalize("ì")))
  expect_true(grepl("^[^A-Za-z]*i", normalize("î")))
  expect_true(grepl("^[^A-Za-z]*i", normalize("ï")))
  expect_true(grepl("^[^A-Za-z]*o", normalize("ó")))
  expect_true(grepl("^[^A-Za-z]*o", normalize("ò")))
  expect_true(grepl("^[^A-Za-z]*o", normalize("ô")))
  expect_true(grepl("^[^A-Za-z]*o", normalize("ö")))
  expect_true(grepl("^[^A-Za-z]*u", normalize("ú")))
  expect_true(grepl("^[^A-Za-z]*u", normalize("ù")))
  expect_true(grepl("^[^A-Za-z]*u", normalize("û")))
  expect_true(grepl("^[^A-Za-z]*u", normalize("ü")))
  expect_true(grepl("^[^A-Za-z]*w", normalize("ẃ")))
  expect_true(grepl("^[^A-Za-z]*w", normalize("ẁ")))
  expect_true(grepl("^[^A-Za-z]*w", normalize("ŵ")))
  expect_true(grepl("^[^A-Za-z]*w", normalize("ẅ")))
  expect_true(grepl("^[^A-Za-z]*y", normalize("ý")))
  expect_true(grepl("^[^A-Za-z]*y", normalize("ỳ")))
  expect_true(grepl("^[^A-Za-z]*y", normalize("ŷ")))
  expect_true(grepl("^[^A-Za-z]*y", normalize("ÿ")))

  expect_true(grepl("^[^A-Za-z]*a", normalize("Á")))
  expect_true(grepl("^[^A-Za-z]*a", normalize("À")))
  expect_true(grepl("^[^A-Za-z]*a", normalize("Â")))
  expect_true(grepl("^[^A-Za-z]*a", normalize("Ä")))
  expect_true(grepl("^[^A-Za-z]*e", normalize("É")))
  expect_true(grepl("^[^A-Za-z]*e", normalize("È")))
  expect_true(grepl("^[^A-Za-z]*e", normalize("Ê")))
  expect_true(grepl("^[^A-Za-z]*e", normalize("Ë")))
  expect_true(grepl("^[^A-Za-z]*i", normalize("Í")))
  expect_true(grepl("^[^A-Za-z]*i", normalize("Ì")))
  expect_true(grepl("^[^A-Za-z]*i", normalize("Î")))
  expect_true(grepl("^[^A-Za-z]*i", normalize("Ï")))
  expect_true(grepl("^[^A-Za-z]*o", normalize("Ó")))
  expect_true(grepl("^[^A-Za-z]*o", normalize("Ò")))
  expect_true(grepl("^[^A-Za-z]*o", normalize("Ô")))
  expect_true(grepl("^[^A-Za-z]*o", normalize("Ö")))
  expect_true(grepl("^[^A-Za-z]*u", normalize("Ú")))
  expect_true(grepl("^[^A-Za-z]*u", normalize("Ù")))
  expect_true(grepl("^[^A-Za-z]*u", normalize("Û")))
  expect_true(grepl("^[^A-Za-z]*u", normalize("Ü")))
  expect_true(grepl("^[^A-Za-z]*w", normalize("Ẃ")))
  expect_true(grepl("^[^A-Za-z]*w", normalize("Ẁ")))
  expect_true(grepl("^[^A-Za-z]*w", normalize("Ŵ")))
  expect_true(grepl("^[^A-Za-z]*w", normalize("Ẅ")))
  expect_true(grepl("^[^A-Za-z]*y", normalize("Ý")))
  expect_true(grepl("^[^A-Za-z]*y", normalize("Ỳ")))
  expect_true(grepl("^[^A-Za-z]*y", normalize("Ŷ")))
  expect_true(grepl("^[^A-Za-z]*y", normalize("Ÿ")))
})
