% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{getTableInfo}
\alias{getTableInfo}
\title{getTableInfo}
\usage{
getTableInfo(auth, report.suite.id, vars = c("id", "name", "menuPath",
  "datasource", "tableName", "segmentable"))
}
\arguments{
\item{auth}{Authentication instance. result of \code{\link{authenticate}} function}

\item{report.suite.id}{ID number (as numeric or character) of datasuite. Can be obtained using the function \code{getDatasuiteInfo} (column \code{d.s.id})}

\item{vars}{info to download (column names of the output dataframe). \code{tableName} is the data warehouse name of the table, \code{name} is the name displayed in the UI.}
}
\value{
R data frame containing one row per table in the datasuite report.suite.id
}
\description{
List all the tables for a specific datasuite
}
\examples{
username <- "demo.user@demoanametrix.com"
password <- "password"
if (!authenticationCheck(auth)) 
auth <- authenticate("https://demo.anametrix.com/api", username, password)
tables.df  <- getTableInfo(auth, report.suite.id = 10385)

}
\seealso{
Other metadata functions: \code{\link{getAccountInfo}},
  \code{\link{getDatasuiteInfo}},
  \code{\link{getDetailedInfo}},
  \code{\link{getReplacementNames}},
  \code{\link{getSegmentInfo}},
  \code{\link{getVariableInfo}}
}

