% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/droplet-actions.R
\name{droplet_modify}
\alias{droplet_change_kernel}
\alias{droplet_modify}
\alias{droplet_rebuild}
\alias{droplet_rename}
\alias{droplet_resize}
\title{Modify a droplet.}
\usage{
droplet_resize(droplet, size, ...)

droplet_rebuild(droplet, image, ...)

droplet_rename(droplet, name, ...)

droplet_change_kernel(droplet, kernel, ...)
}
\arguments{
\item{droplet}{A droplet, or something that can be coerced to a droplet by
\code{\link{as.droplet}}.}

\item{size}{(character) Size slug (name) of the image size. See \code{sizes}}

\item{...}{Additional options passed down to low-level API method.}

\item{image}{(optional) The image ID of the backup image that you would like to restore.}

\item{name}{(character) The new name for the droplet}

\item{kernel}{(numeric) The ID of the new kernel.}
}
\description{
These methods allow you to modify existing droplets.
}
\details{
\describe{
\item{resize}{Resize a specific droplet to a different size. This will
  affect the number of processors and memory allocated to the droplet.}
\item{rebuild}{Reinstall a droplet with a default image. This is useful if you want
  to start again but retain the same IP address for your droplet.}
\item{rename}{Change the droplet name}
\item{change_kernel}{Change kernel ID.}
}

Beware: \code{droplet_resize()} does not seem to work, see \code{resize()}
}
\examples{
\dontrun{
droplets()[[1]] \%>\% droplet_rename(name='newname')
}
}

