% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{distributions}
\alias{distributions}
\alias{make_distribution}
\alias{make_exp_distr}
\alias{make_unif_distr}
\alias{make_vonmises_distr}
\alias{make_gamma_distr}
\alias{random_numbers}
\alias{random_numbers.vonmises_distr}
\alias{random_numbers.amt_distr}
\title{Functions to work with distributions as objects}
\usage{
make_distribution(name, params, ...)

make_exp_distr(rate = 1)

make_unif_distr(min = -pi, max = pi)

make_vonmises_distr(kappa = 1)

make_gamma_distr(shape = 1, scale = 1)

random_numbers(x, n = 100, ...)

\method{random_numbers}{vonmises_distr}(x, n = 100, ...)

\method{random_numbers}{amt_distr}(x, n = 100, ...)
}
\arguments{
\item{name}{\verb{[char(1)]} \cr Short name of distribution. See \code{available_distr()}
for all currently implemented distributions.}

\item{params}{\verb{[list]} \cr A named list with parameters of the distribution.}

\item{...}{none implemented.}

\item{rate}{\verb{[double(1)>0]} \cr The rate of the exponential distribution.}

\item{min}{\verb{[double(1)]} \cr The minimum of the uniform distribution.}

\item{max}{\verb{[double(1)]} \cr The minimum of the uniform distribution.}

\item{kappa}{\verb{[double(1)>=0]} \cr Concentration parameter of the von Mises distribution.}

\item{shape, scale}{\verb{[double(1)>=0]} \cr Shape and scale of the Gamma distribution}

\item{x}{\verb{[amt_distr]} \cr A distribution object.}

\item{n}{\verb{[integer(1)=100]\{>0\}} \cr The number of random draws.}
}
\description{
\code{make_distributions} creates a distribution.
}
