% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_covariates.R
\name{extract_covariates}
\alias{extract_covariates}
\alias{extract_covariates.track_xy}
\alias{extract_covariates.random_points}
\alias{extract_covariates.steps_xy}
\alias{extract_covariates_along}
\alias{extract_covariates_along.steps_xy}
\alias{extract_covariates_var_time}
\alias{extract_covariates_var_time.track_xyt}
\alias{extract_covariates_var_time.steps_xyt}
\title{Extract covariate values}
\usage{
extract_covariates(x, ...)

\method{extract_covariates}{track_xy}(x, covariates, ...)

\method{extract_covariates}{random_points}(x, covariates, ...)

\method{extract_covariates}{steps_xy}(x, covariates, where = "end", ...)

extract_covariates_along(x, ...)

\method{extract_covariates_along}{steps_xy}(x, covariates, ...)

extract_covariates_var_time(x, ...)

\method{extract_covariates_var_time}{track_xyt}(x, covariates,
  when = "any", max_time, name_covar = "time_var_covar", ...)

\method{extract_covariates_var_time}{steps_xyt}(x, covariates,
  when = "any", max_time, name_covar = "time_var_covar",
  where = "end", ...)
}
\arguments{
\item{x}{\code{[track_xy, track_xyt, steps]} \cr Either a track created with \code{mk_track} or \code{track}, or \code{steps}.}

\item{...}{Further arguments, none implemented.}

\item{covariates}{\code{[RasterLayer,RasterStack,RasterBrick]} \cr The
(environmental) covariates. For \code{extract_covariates_var_time} the argument
\code{covariates} need to have a \code{z}-columne (i.e. the time stamp).}

\item{where}{\code{[character(1)="end"]{"start", "end", "both"}} \cr For \code{steps} this
determines if the covariate values should be extracted at the beginning or
the end of a step. or \code{end}.}

\item{when}{\code{[character(1)="any"]{"any", "before", "after"}} \cr Specifies for
for \code{extract_covariates_var_time} whether to look before, after or in both
direction (\code{any}) for the temporally closest environmental raster.}

\item{max_time}{\code{[Period(1)]} \cr The maximum time difference between a relocation
and the corresponding raster. If no rasters are within the specified max.
distance \code{NA} is returned.}

\item{name_covar}{\code{[character(1)="time_var_covar"]} \cr The name of the new column.}
}
\description{
Extract the covariate values at relocations, or at the beginning or end of
steps.
}
\details{
\code{extract_covariates_along} extracts the covariates along a straight line between the start and the end point of a (random) step. It returns a list, which in most cases will have to be processed further.
}
\examples{
data(deer)
data(sh_forest)
deer \%>\% extract_covariates(sh_forest)
deer \%>\% steps \%>\% extract_covariates(sh_forest)
deer \%>\% steps \%>\% extract_covariates(sh_forest, where = "start")
\dontrun{
data(deer) # relocation
data("sh_forest") # env covar

p1 <- deer \%>\% steps() \%>\% random_steps() \%>\%
  extract_covariates(sh_forest) \%>\% # extract at the endpoint
  mutate(for_path = extract_covariates_along(., sh_forest))  \%>\%
  # 1 = forest, lets calc the fraction of forest along the path
  mutate(for_per = purrr::map_dbl(for_path, ~ mean(. == 1)))
}

# Simulate some dummy data
# Hourly data for 10 days: 24 * 10
set.seed(123)
path <- data.frame(x = cumsum(rnorm(240)),
              y = cumsum(rnorm(240)),
              t = lubridate::ymd("2018-01-01") + hours(0:239))
trk <- make_track(path, x, y, t)

# dummy env data
rs <- raster::raster(xmn = -50, xmx = 50, ymn = -50, ymx = 50, res = 1)

# create dummy covars for each day
rs <- raster::stack(lapply(1:10, function(i)
  raster::setValues(rs, runif(1e4, i - 1, i))))

# Env covariates are always taken at noon
rs <- raster::setZ(rs, lubridate::ymd_hm("2018-01-01 12:00") + days(0:9))

# Allow up to 2 hours after
trk \%>\% extract_covariates_var_time(rs, max_time = hours(2), when = "after") \%>\%
  print(n = 25)
trk \%>\% extract_covariates_var_time(rs, max_time = hours(2), when = "before") \%>\%
  print(n = 25)
trk \%>\% extract_covariates_var_time(rs, max_time = hours(2), when = "any") \%>\%
  print(n = 25)

# We can use different time scales
trk \%>\%
  extract_covariates_var_time(
    rs, max_time = hours(2), when = "any", name_covar = "env_2h") \%>\%
  extract_covariates_var_time(
    rs, max_time = hours(4), when = "any", name_covar = "env_4h") \%>\%
  extract_covariates_var_time(
    rs, max_time = hours(6), when = "any", name_covar = "env_6h") \%>\%
  print(n = 25)

# We can use different time scales: after
trk \%>\%
  extract_covariates_var_time(
    rs, max_time = hours(2), when = "after", name_covar = "env_2h") \%>\%
  extract_covariates_var_time(
    rs, max_time = hours(4), when = "after", name_covar = "env_4h") \%>\%
  extract_covariates_var_time(
    rs, max_time = hours(6), when = "after", name_covar = "env_6h") \%>\%
  print(n = 25)

# We can use different time scales: before
trk \%>\%
  extract_covariates_var_time(
    rs, max_time = hours(2), when = "before", name_covar = "env_2h") \%>\%
  extract_covariates_var_time(
    rs, max_time = hours(4), when = "before", name_covar = "env_4h") \%>\%
  extract_covariates_var_time(
    rs, max_time = hours(6), when = "before", name_covar = "env_6h") \%>\%
  print(n = 25)

# The same works also for steps
trk \%>\%
  steps() \%>\%
  extract_covariates_var_time(
    rs, max_time = hours(2), when = "before", name_covar = "env_2h") \%>\%
  print(n = 25)

# also with start and end
trk \%>\%
  steps() \%>\%
  extract_covariates_var_time(
    rs, max_time = hours(2), when = "before", name_covar = "env_2h",
    where = "both") \%>\%
  print(n = 25)

}
