% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_covariates.R
\name{extract_covariates}
\alias{extract_covariates}
\alias{extract_covariates.track_xy}
\alias{extract_covariates.random_points}
\alias{extract_covariates.steps}
\title{Extract covariate values}
\usage{
extract_covariates(x, ...)

\method{extract_covariates}{track_xy}(x, covariates, ...)

\method{extract_covariates}{random_points}(x, covariates, ...)

\method{extract_covariates}{steps}(x, covariates, where = "end", ...)
}
\arguments{
\item{x}{\code{[track_xy, track_xyt, steps]} \cr Either a track created with \code{mk_track} or \code{track}, or \code{steps}.}

\item{...}{Further arguments, none implemented.}

\item{covariates}{\code{[RasterLayer,RasterStack,RasterBrick]} \cr The
(environmental) covariates.}

\item{where}{\code{[character(1)="end"]{"start", "end", "both"}} \cr For \code{steps} this
determines if the covariate values should be extracted at the beginning or
the end of a step. or \code{end}.}
}
\description{
Extract the covariate values at relocations, or at the beginning or end of
steps.
}
\examples{
data(deer)
data(sh_forest)
deer \%>\% extract_covariates(sh_forest)
deer \%>\% steps \%>\% extract_covariates(sh_forest)
deer \%>\% steps \%>\% extract_covariates(sh_forest, where = "start")
}
