% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_features.R
\name{calculate_features}
\alias{calculate_features}
\title{Calculate a set of numerical features from protein sequences}
\usage{
calculate_features(df, min_len = 20)
}
\arguments{
\item{df}{A dataframe which contains protein sequence names as the first column and amino acid sequence as the second column}

\item{min_len}{Minimum length sequence for which features can be calculated. It is an error to provide sequences with length shorter than this}
}
\value{
A dataframe containing numerical values related to the protein features of each given protein
}
\description{
This function calculates set physicochemical and compositional features from protein sequences
}
\note{
This function depends on the Peptides package
}
\references{
Osorio, D., Rondon-Villarreal, P. & Torres, R. Peptides: A package for data mining of antimicrobial peptides. The R Journal. 7(1), 4–14 (2015).
}
