% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amf_filter_base.R
\name{amf_filter_base}
\alias{amf_filter_base}
\title{Filter AmeriFlux BASE data based on plausible range}
\usage{
amf_filter_base(
  data_in,
  limit_ls = NULL,
  basename_decode = NULL,
  loose_filter = 0.05
)
}
\arguments{
\item{data_in}{A data frame containing BASE data, e.g.,
import from \code{\link{amf_read_base}}.}

\item{limit_ls}{A data frame with at least three columns:
\itemize{
  \item Name: variable base name
  \item Min: expected lower bound
  \item Max: expected upper bound
 }
 If not specified, use \code{\link{amf_variables}} by default.}

\item{basename_decode}{A data frame with at least two columns:
\itemize{
  \item variable_name: actual variable name
  \item basename: variable base name
 }
 If not specified, use \code{\link{amf_parse_basename}} by default.}

\item{loose_filter}{A number in ratio (0-1) used to adjust the physical
range for filtering. Set it to 0 if not used. The default is 0.05.}
}
\value{
A data frame similar to \code{data_in} filtered out off-range points
}
\description{
The function filters BASE data based on the expected
plausible ranges specified for each variable. See AmeriFlux web site
\url{https://ameriflux.lbl.gov/data/data-processing-pipelines/data-qaqc/}
for description of the plausible ranges.
}
\examples{
\dontrun{
# read the BASE from a csv file
base <- amf_read_base(file = system.file("extdata",
                                         "AMF_US-CRT_BASE_HH_2-5.csv",
                                          package = "amerifluxr"),
                      unzip = FALSE,
                      parse_timestamp = FALSE)

# filter data, using default physical range +/- 5\% buffer
base_f <- amf_filter_base(data_in = base)

# filter data, using default physical range without buffer
base_f <- amf_filter_base(data_in = base, loose_filter = 0)
}
}
