% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raSab_cbin_fc.R
\name{raSab_cbin_fc}
\alias{raSab_cbin_fc}
\title{Simulate a and Sab from full conditional distributions under the cbin
likelihood}
\usage{
raSab_cbin_fc(Z, Y, a, b, Sab, odmax, odobs, Sab0=NULL, eta0=NULL,SS =
round(sqrt(nrow(Z))))
}
\arguments{
\item{Z}{a square matrix, the current value of Z}

\item{Y}{square matrix of ranked nomination data}

\item{a}{current value of row effects}

\item{b}{current value of column effects}

\item{Sab}{current value of Cov(a,b)}

\item{odmax}{a scalar or vector giving the maximum number of nominations for
each individual}

\item{odobs}{observed outdegree}

\item{Sab0}{prior (inverse) scale matrix for the prior distribution}

\item{eta0}{prior degrees of freedom for the prior distribution}

\item{SS}{number of iterations}
}
\value{
\item{Z}{new value of Z} \item{Sab}{new value of Sab} \item{a}{new
value of a}
}
\description{
Simulate a and Sab from full conditional distributions under the cbin
likelihood
}
\author{
Peter Hoff
}
