% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ambiorix.R
\name{Ambiorix}
\alias{Ambiorix}
\title{Ambiorix}
\value{
An object of class \code{Ambiorix} from which one can
add routes, routers, and run the application.
}
\description{
Web server.
}
\examples{
app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

app$on_stop <- function(){
 cat("Bye!\n")
}

if(interactive())
 app$start()


## ------------------------------------------------
## Method `Ambiorix$listen`
## ------------------------------------------------

app <- Ambiorix$new()

app$listen(3000L)

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()

## ------------------------------------------------
## Method `Ambiorix$set_404`
## ------------------------------------------------

app <- Ambiorix$new()

app$set_404(function(req, res){
 res$send("Nothing found here")
})

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()

## ------------------------------------------------
## Method `Ambiorix$start`
## ------------------------------------------------

app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$list(posrt = 3000L)

## ------------------------------------------------
## Method `Ambiorix$serialiser`
## ------------------------------------------------

app <- Ambiorix$new()

app$serialiser(function(data, ...){
 jsonlite::toJSON(x, ..., pretty = TRUE)
})

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()
}
\section{Super class}{
\code{\link[ambiorix:Routing]{ambiorix::Routing}} -> \code{Ambiorix}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{not_found}}{404 Response, must be a handler function that accepts the request and the response, by default uses \code{\link[=response_404]{response_404()}}.}

\item{\code{error}}{500 response when the route errors, must a handler function that accepts the request and the response, by default uses \code{\link[=response_500]{response_500()}}.}

\item{\code{on_stop}}{Callback function to run when the app stops, takes no argument.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{port}}{Port to run the application.}

\item{\code{host}}{Host to run the application.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Ambiorix$new()}}
\item \href{#method-listen}{\code{Ambiorix$listen()}}
\item \href{#method-set_404}{\code{Ambiorix$set_404()}}
\item \href{#method-static}{\code{Ambiorix$static()}}
\item \href{#method-start}{\code{Ambiorix$start()}}
\item \href{#method-serialiser}{\code{Ambiorix$serialiser()}}
\item \href{#method-stop}{\code{Ambiorix$stop()}}
\item \href{#method-print}{\code{Ambiorix$print()}}
\item \href{#method-clone}{\code{Ambiorix$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="all">}\href{../../ambiorix/html/Routing.html#method-all}{\code{ambiorix::Routing$all()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="delete">}\href{../../ambiorix/html/Routing.html#method-delete}{\code{ambiorix::Routing$delete()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="get">}\href{../../ambiorix/html/Routing.html#method-get}{\code{ambiorix::Routing$get()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="get_middleware">}\href{../../ambiorix/html/Routing.html#method-get_middleware}{\code{ambiorix::Routing$get_middleware()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="get_receivers">}\href{../../ambiorix/html/Routing.html#method-get_receivers}{\code{ambiorix::Routing$get_receivers()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="get_routes">}\href{../../ambiorix/html/Routing.html#method-get_routes}{\code{ambiorix::Routing$get_routes()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="options">}\href{../../ambiorix/html/Routing.html#method-options}{\code{ambiorix::Routing$options()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="patch">}\href{../../ambiorix/html/Routing.html#method-patch}{\code{ambiorix::Routing$patch()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="post">}\href{../../ambiorix/html/Routing.html#method-post}{\code{ambiorix::Routing$post()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="put">}\href{../../ambiorix/html/Routing.html#method-put}{\code{ambiorix::Routing$put()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="receive">}\href{../../ambiorix/html/Routing.html#method-receive}{\code{ambiorix::Routing$receive()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="ambiorix" data-topic="Routing" data-id="use">}\href{../../ambiorix/html/Routing.html#method-use}{\code{ambiorix::Routing$use()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$new(
  host = getOption("ambiorix.host", "0.0.0.0"),
  port = getOption("ambiorix.port", NULL),
  log = getOption("ambiorix.logger", TRUE)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host}}{A string defining the host.}

\item{\code{port}}{Integer defining the port, defaults to \code{ambiorix.port} option: uses a random port if \code{NULL}.}

\item{\code{log}}{Whether to generate a log of events.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Define the webserver.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-listen"></a>}}
\if{latex}{\out{\hypertarget{method-listen}{}}}
\subsection{Method \code{listen()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$listen(port)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{port}}{Port number.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Specifies the port to listen on.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{app <- Ambiorix$new()

app$listen(3000L)

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_404"></a>}}
\if{latex}{\out{\hypertarget{method-set_404}{}}}
\subsection{Method \code{set_404()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$set_404(handler)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{handler}}{Function that accepts the request and returns an object
describing an httpuv response, e.g.: \code{\link[=response]{response()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Sets the 404 page.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{app <- Ambiorix$new()

app$set_404(function(req, res){
 res$send("Nothing found here")
})

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-static"></a>}}
\if{latex}{\out{\hypertarget{method-static}{}}}
\subsection{Method \code{static()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$static(path, uri = "www")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{Local path to directory of assets.}

\item{\code{uri}}{URL path where the directory will be available.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Static directories
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-start"></a>}}
\if{latex}{\out{\hypertarget{method-start}{}}}
\subsection{Method \code{start()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$start(port = NULL, host = NULL, open = interactive())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{port}}{Integer defining the port, defaults to \code{ambiorix.port} option: uses a random port if \code{NULL}.}

\item{\code{host}}{A string defining the host.}

\item{\code{open}}{Whether to open the app the browser.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Start
Start the webserver.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{app <- Ambiorix$new()

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$list(posrt = 3000L)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-serialiser"></a>}}
\if{latex}{\out{\hypertarget{method-serialiser}{}}}
\subsection{Method \code{serialiser()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$serialiser(handler)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{handler}}{Function to use to serialise.
This function should accept two arguments: the object to serialise and \code{...}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Define Serialiser
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{app <- Ambiorix$new()

app$serialiser(function(data, ...){
 jsonlite::toJSON(x, ..., pretty = TRUE)
})

app$get("/", function(req, res){
 res$send("Using {ambiorix}!")
})

if(interactive())
 app$start()
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-stop"></a>}}
\if{latex}{\out{\hypertarget{method-stop}{}}}
\subsection{Method \code{stop()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$stop()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Stop
Stop the webserver.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Print
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ambiorix$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
