% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/white.R
\name{noise_white}
\alias{noise_white}
\title{White noise generator}
\usage{
noise_white(dim, frequency = 0.01, pertubation = "none",
  pertubation_amplitude = 1)
}
\arguments{
\item{dim}{The dimensions (height, width, (and depth, (and time))) of the
noise to be generated. The length determines the dimensionality of the noise.}

\item{frequency}{Determines the granularity of the features in the noise.}

\item{pertubation}{The pertubation to use. Either \code{'none'} (default),
\code{'normal'}, or \code{'fractal'}. Defines the displacement (warping) of the noise,
with \code{'normal'} giving a smooth warping and \code{'fractal'} giving a more eratic
warping.}

\item{pertubation_amplitude}{The maximal pertubation distance from the
origin. Ignored if \code{pertubation = 'none'}. Defaults to \code{1}.}
}
\value{
If \code{length(dim) == 2} a matrix, if \code{length(dim) \%in\% c(3, 4)} a 3- or
4-dimensional array.
}
\description{
White noise is a random noise with equal intensities at different
frequencies. It is most well-known as what appeared on old televisions when
no signal was found.
}
\examples{
# Basic use
noise <- noise_white(c(100, 100))

image(noise, col = grey.colors(256, 0, 1))

}
