% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotZonalMeanStats.R
\name{plotZonalMeanStats}
\alias{plotZonalMeanStats}
\title{Plot zonal mean plots of AMBER results (bias, bias scores, etc)}
\usage{
plotZonalMeanStats(zonalMeanStats, zonalMeanStatsUnits,
  lat.range = c(-50, 80), outputDir = FALSE)
}
\arguments{
\item{zonalMeanStats}{A string that gives the name and location of the zonalMeanStats file produced by \link{zonalMeanStats}, e.g. '/home/project/study/zonalMeanStats'.}

\item{zonalMeanStatsUnits}{A string that gives the name and location of the zonalMeanStatsUnits file produced by \link{zonalMeanStats}, e.g. '/home/project/study/zonalMeanStatsUnits'.}

\item{lat.range}{Latitudinal range of ticks and labels on the horizontal axis, e.g. c(-50, 80).}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory.}
}
\value{
Figures that show zonal mean values of model and reference data, centralized root-mean-square error, phase, inter-annual variability, and corresponding
scores for each variable and globally gridded reference data set.
}
\description{
This function plots results from \link{zonalMeanStats}, i.e. zonal mean values of model and reference data and the zonal mean bias, centralized root-mean-square error, phase, inter-annual variability, and corresponding scores.
}
\examples{
library(amber)
library(classInt)
library(doParallel)
library(foreach)
library(Hmisc)
library(latex2exp)
library(ncdf4)
library(parallel)
library(raster)
library(rgdal)
library(rgeos)
library(scico)
library(sp)
library(stats)
library(utils)
library(viridis)
library(xtable)

zonalMeanStats <- system.file('extdata/zonalMeanStats', 'zonalMeanStats', package = 'amber')
zonalMeanStatsUnits <- system.file('extdata/zonalMeanStats',
 'zonalMeanStatsUnits', package = 'amber')
plotZonalMeanStats(zonalMeanStats, zonalMeanStatsUnits, outputDir = FALSE)

}
