% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intFun.R
\name{intFun.iav}
\alias{intFun.iav}
\title{Inter-annual variability}
\usage{
intFun.iav(anom)
}
\arguments{
\item{anom}{R object with monthly anomalies}
}
\value{
R object with inter-annual variability
}
\description{
This function computes the inter-annual variability. All data must start in January. All months after the last Dec will be dropped if data does not end in December.
}
\examples{

# make some data
month <- seq(1,12,1)
month <- rep(month,10)
mod <- runif(length(month), 0,100)
mod <- data.frame(month, mod)
# compute climatological mean monthly values
index <- list(mod$month)
mod.clim.mly <- apply(mod, 2, function(x) {tapply(x, index, mean, na.rm=TRUE)})
mod.anom <- intFun.anom.mly(mod, mod.clim.mly)
mod.iav <- intFun.iav(mod.anom)

}
\keyword{internal}
