% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download_nei}
\alias{download_nei}
\title{Download road emissions data}
\usage{
download_nei(
  epa_certificate_path = system.file("extdata/cacert_gaftp_epa.pem", package = "amadeus"),
  certificate_url =
    "http://cacerts.digicert.com/DigiCertGlobalG2TLSRSASHA2562020CA1-1.crt",
  year = c(2017L, 2020L),
  directory_to_save = NULL,
  acknowledgement = FALSE,
  download = FALSE,
  remove_command = FALSE,
  unzip = TRUE,
  hash = FALSE
)
}
\arguments{
\item{epa_certificate_path}{character(1). Path to the certificate file
for EPA DataCommons. Default is
'extdata/cacert_gaftp_epa.pem' under the package installation path.}

\item{certificate_url}{character(1). URL to certificate file. See notes for
details.}

\item{year}{Available years of NEI data.
Default is \code{c(2017L, 2020L)}.}

\item{directory_to_save}{character(1). Directory to save data. Two
sub-directories will be created for the downloaded zip files ("/zip_files")
and the unzipped data files ("/data_files").}

\item{acknowledgement}{logical(1). By setting \code{TRUE} the
user acknowledges that the data downloaded using this function may be very
large and use lots of machine storage and memory.}

\item{download}{logical(1). \code{FALSE} will generate a *.txt file
containing all download commands. By setting \code{TRUE} the function
will download all of the requested data files.}

\item{remove_command}{logical(1).
Remove (\code{TRUE}) or keep (\code{FALSE})
the text file containing download commands.}

\item{unzip}{logical(1). Unzip the downloaded zip files.
Default is \code{FALSE}.}

\item{hash}{logical(1). By setting \code{TRUE} the function will return
an \code{rlang::hash_file()} hash character corresponding to the
downloaded files. Default is \code{FALSE}.}
}
\value{
\itemize{
\item For \code{hash = FALSE}, NULL
\item For \code{hash = TRUE}, an \code{rlang::hash_file} character.
\item Zip and/or data files will be downloaded and stored in
respective sub-directories within \code{directory_to_save}.
}
}
\description{
The \code{download_nei()} function accesses and downloads road emissions data from the \href{https://www.epa.gov/air-emissions-inventories/national-emissions-inventory-nei}{U.S Environmental Protection Agency's (EPA) National Emissions Inventory (NEI)}.
}
\note{
For EPA Data Commons certificate errors, follow the steps below:
\enumerate{
\item Click Lock icon in the address bar at https://gaftp.epa.gov
\item Click Show Certificate
\item Access Details
\item Find URL with *.crt extension
Currently we bundle the pre-downloaded crt and its PEM (which is accepted
in wget command) file in ./inst/extdata. The instruction above is for
certificate updates in the future.
}
}
\examples{
download_nei(
  year = c(2017L, 2020L),
  directory_to_save = tempdir(),
  acknowledgement = TRUE,
  download = FALSE, # NOTE: download skipped for examples,
  remove_command = TRUE,
  unzip = FALSE
)
}
\references{
\insertRef{web_usepa2024nei}{amadeus}
}
\author{
Ranadeep Daw, Insang Song
}
